/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransaction;
import org.mule.transport.ConnectException;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.filters.JmsSelectorFilter;
import org.mule.transport.jms.redelivery.RedeliveryHandler;
import org.mule.util.ClassUtils;
import org.mule.util.MapUtils;

public class XaTransactedJmsMessageReceiver
extends TransactedPollingMessageReceiver {
    public static final long DEFAULT_JMS_POLL_FREQUENCY = 100L;
    public static final TimeUnit DEFAULT_JMS_POLL_TIMEUNIT = TimeUnit.MILLISECONDS;
    protected final JmsConnector connector;
    private final long localTimeout;
    protected boolean reuseConsumer;
    protected boolean reuseSession;
    protected final ThreadContextLocal context = new ThreadContextLocal();
    protected final long timeout;
    private final AtomicReference<RedeliveryHandler> redeliveryHandler = new AtomicReference();
    private final boolean topic;

    public boolean shouldConsumeInEveryNode() {
        return !this.topic;
    }

    public XaTransactedJmsMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setTimeUnit(DEFAULT_JMS_POLL_TIMEUNIT);
        this.setFrequency(100L);
        this.connector = (JmsConnector)connector;
        this.timeout = endpoint.getTransactionConfig().getTimeout();
        if (this.retryTemplate != null && !(this.retryTemplate instanceof NoRetryPolicyTemplate)) {
            this.reuseConsumer = false;
            this.reuseSession = false;
        }
        this.reuseConsumer = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"reuseConsumer", (boolean)this.reuseConsumer);
        this.reuseSession = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"reuseSession", (boolean)this.reuseSession);
        this.topic = this.connector.getTopicResolver().isTopic((ImmutableEndpoint)this.getEndpoint());
        if (this.topic && (this.reuseConsumer || this.reuseSession)) {
            this.logger.warn((Object)("Destination " + this.getEndpoint().getEndpointURI() + " is a topic and XA transaction was " + "configured. Forcing 'reuseSession' and 'reuseConsumer' to false. Set these " + "on endpoint to avoid the message."));
            this.reuseConsumer = false;
            this.reuseSession = false;
        }
        this.setUseMultipleTransactedReceivers(!this.topic);
        this.localTimeout = this.resolveReceiveTimeout();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        if (this.redeliveryHandler.compareAndSet(null, this.connector.getRedeliveryHandlerFactory().create())) {
            this.redeliveryHandler.get().setConnector(this.connector);
        }
    }

    protected void doDisconnect() throws Exception {
        if (this.connector.isConnected()) {
            this.closeResource(true);
        }
    }

    public void poll() throws Exception {
        this.logger.debug((Object)"Polling...");
        ExecutionTemplate processingCallback = this.createExecutionTemplate();
        ExecutionCallback<MuleEvent> cb = new ExecutionCallback<MuleEvent>(){

            public MuleEvent process() throws Exception {
                try {
                    return this.doProcess();
                }
                catch (Exception e) {
                    JmsThreadContext ctx = XaTransactedJmsMessageReceiver.this.context.getContext();
                    if (ctx.consumer != null) {
                        XaTransactedJmsMessageReceiver.this.connector.closeQuietly(ctx.consumer);
                    }
                    ctx.consumer = null;
                    Transaction tx = TransactionCoordination.getInstance().getTransaction();
                    if (ctx.session != null && tx instanceof XaTransaction.MuleXaObject) {
                        if (ctx.session instanceof XaTransaction.MuleXaObject) {
                            ((XaTransaction.MuleXaObject)ctx.session).setReuseObject(false);
                        } else {
                            XaTransactedJmsMessageReceiver.this.logger.warn((Object)("Session should be XA, but is of type " + ctx.session.getClass().getName()));
                        }
                    }
                    ctx.session = null;
                    throw e;
                }
            }

            protected MuleEvent doProcess() throws Exception {
                try {
                    List<MuleMessage> messages = XaTransactedJmsMessageReceiver.this.getMessages();
                    if (messages != null && messages.size() > 0) {
                        for (MuleMessage message : messages) {
                            XaTransactedJmsMessageReceiver.this.processMessage(message);
                        }
                    }
                    return null;
                }
                catch (JMSException e) {
                    throw new ConnectException((Throwable)e, (Connectable)XaTransactedJmsMessageReceiver.this);
                }
                catch (Exception e) {
                    if (e.getCause() != null && e.getCause() instanceof JMSException) {
                        throw new ConnectException(e.getCause(), (Connectable)XaTransactedJmsMessageReceiver.this);
                    }
                    throw e;
                }
            }
        };
        processingCallback.execute((ExecutionCallback)cb);
    }

    private void handlePossibleDisconnectingException(Exception e) throws Exception {
        boolean isJMSException;
        boolean bl = isJMSException = e instanceof JMSException || e instanceof UndeclaredThrowableException && ((UndeclaredThrowableException)e).getUndeclaredThrowable().getCause() instanceof JMSException;
        if (isJMSException && !this.isConnected()) {
            return;
        }
        throw e;
    }

    protected List<MuleMessage> getMessages() throws Exception {
        Session session = (Session)this.connector.getTransactionalResource(this.endpoint);
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        MessageConsumer consumer = this.createConsumer();
        Message message = null;
        try {
            message = consumer.receive(this.localTimeout);
        }
        catch (Exception e) {
            this.handlePossibleDisconnectingException(e);
        }
        if (message == null) {
            if (tx != null) {
                tx.setRollbackOnly();
            }
            this.closeConsumerIfRequired(consumer);
            return null;
        }
        message = this.connector.preProcessMessage(message, session);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message received it is of type: " + ClassUtils.getSimpleName(message.getClass())));
            if (message.getJMSDestination() != null) {
                this.logger.debug((Object)("Message received on " + message.getJMSDestination() + " (" + message.getJMSDestination().getClass().getName() + ")"));
            } else {
                this.logger.debug((Object)"Message received on unknown destination");
            }
            this.logger.debug((Object)("Message CorrelationId is: " + message.getJMSCorrelationID()));
            this.logger.debug((Object)("Jms Message Id is: " + message.getJMSMessageID()));
        }
        if (message.getJMSRedelivered()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message with correlationId: " + message.getJMSCorrelationID() + " is redelivered. handing off to Exception Handler"));
            }
            this.redeliveryHandler.get().handleRedelivery(message, (InboundEndpoint)this.endpoint, this.flowConstruct);
        }
        MuleMessage messageToRoute = this.createMuleMessage(message, this.endpoint.getEncoding());
        this.routeMessage(messageToRoute);
        this.closeConsumerIfRequired(consumer);
        return null;
    }

    private long resolveReceiveTimeout() {
        long localTimeout = MapUtils.getLongValue((Map)this.endpoint.getProperties(), (Object)"xaPollingTimeout", (long)this.timeout);
        if (localTimeout > this.timeout) {
            this.logger.warn((Object)String.format("Transaction timeout ('%s') must be greater than the timeout used for polling messages ('%s'). Using transaction timeout", localTimeout, this.timeout));
            localTimeout = this.timeout;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Consumer is receiving in '%s' ith timeout '%d'", new Object[]{this, localTimeout}));
        }
        return localTimeout;
    }

    private void closeConsumerIfRequired(MessageConsumer consumer) {
        if (!this.reuseConsumer) {
            this.connector.closeQuietly(consumer);
            if (this.context.getContext() != null) {
                this.context.getContext().consumer = null;
            }
        }
    }

    protected MuleEvent processMessage(Object msg) throws Exception {
        return null;
    }

    protected void closeResource(boolean force) {
        JmsThreadContext ctx = this.context.getContext();
        if (ctx == null) {
            return;
        }
        if (force || !this.reuseSession || !this.reuseConsumer) {
            this.connector.closeQuietly(ctx.consumer);
            ctx.consumer = null;
        }
        if (force || !this.reuseSession) {
            this.connector.closeQuietly(ctx.session);
            ctx.session = null;
        }
    }

    protected MessageConsumer createConsumer() throws Exception {
        this.logger.debug((Object)"Create a consumer for the jms destination");
        try {
            String durableName;
            Session session;
            JmsSupport jmsSupport = this.connector.getJmsSupport();
            JmsThreadContext ctx = this.context.getContext();
            if (ctx == null) {
                ctx = new JmsThreadContext();
            }
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            if (this.reuseSession && ctx.session != null) {
                session = ctx.session;
                tx.bindResource((Object)this.connector.getConnection(), (Object)session);
            } else {
                session = this.connector.getSession(this.endpoint);
                if (session != null && tx != null) {
                    if (session instanceof XaTransaction.MuleXaObject) {
                        ((XaTransaction.MuleXaObject)session).setReuseObject(this.reuseSession);
                    } else {
                        this.logger.warn((Object)("Session should be XA, but is of type " + session.getClass().getName()));
                    }
                }
            }
            if (this.reuseSession) {
                ctx.session = session;
            }
            if (this.reuseConsumer && ctx.consumer != null) {
                return ctx.consumer;
            }
            boolean topic = this.connector.getTopicResolver().isTopic(this.endpoint);
            Destination dest = jmsSupport.createDestination(session, this.endpoint);
            String selector = null;
            JmsSelectorFilter selectorFilter = this.connector.getSelector(this.endpoint);
            if (selectorFilter != null) {
                selector = selectorFilter.getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
            }
            MessageConsumer consumer = jmsSupport.createConsumer(session, dest, selector, this.connector.isNoLocal(), durableName, topic, this.endpoint);
            if (this.reuseConsumer) {
                ctx.consumer = consumer;
            }
            return consumer;
        }
        catch (JMSException e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
    }

    protected static class ThreadContextLocal
    extends ThreadLocal<JmsThreadContext> {
        protected ThreadContextLocal() {
        }

        public JmsThreadContext getContext() {
            return (JmsThreadContext)this.get();
        }

        @Override
        protected JmsThreadContext initialValue() {
            return new JmsThreadContext();
        }
    }

    protected static class JmsThreadContext {
        public Session session;
        public MessageConsumer consumer;

        protected JmsThreadContext() {
        }
    }
}

