/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.jndi;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.jms.jndi.JndiNameResolver;

public abstract class AbstractJndiNameResolver
implements JndiNameResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String jndiProviderUrl;
    private String jndiInitialFactory;
    private Map jndiProviderProperties;
    private InitialContextFactory contextFactory = new InitialContextFactory(){

        @Override
        public Context getInitialContext(Hashtable<?, ?> hashtable) throws NamingException {
            return new InitialContext(hashtable);
        }
    };

    protected Context createInitialContext() throws NamingException {
        return this.contextFactory.getInitialContext(this.getContextProperties());
    }

    protected Hashtable getContextProperties() {
        if (!(this.jndiInitialFactory != null || this.jndiProviderProperties != null && this.jndiProviderProperties.containsKey("java.naming.factory.initial"))) {
            throw new IllegalArgumentException("Undefined value for jndiInitialFactory property");
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (this.jndiInitialFactory != null) {
            props.put("java.naming.factory.initial", this.jndiInitialFactory);
        }
        if (this.jndiProviderUrl != null) {
            props.put("java.naming.provider.url", this.jndiProviderUrl);
        }
        if (this.jndiProviderProperties != null) {
            props.putAll(this.jndiProviderProperties);
        }
        return props;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public Map getJndiProviderProperties() {
        return this.jndiProviderProperties;
    }

    public void setJndiProviderProperties(Map jndiProviderProperties) {
        this.jndiProviderProperties = jndiProviderProperties;
    }

    public InitialContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(InitialContextFactory contextFactory) {
        if (contextFactory == null) {
            throw new IllegalArgumentException("Context factory cannot be null");
        }
        this.contextFactory = contextFactory;
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }
}

