/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.multicast;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.mule.providers.multicast.MulticastConnector;
import org.mule.providers.udp.UdpMessageDispatcher;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class MulticastMessageDispatcher
extends UdpMessageDispatcher {
    public MulticastMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
    }

    protected DatagramSocket createSocket(int port, InetAddress inetAddress) throws IOException {
        MulticastSocket socket = new MulticastSocket(port);
        socket.setLoopbackMode(((MulticastConnector)this.connector).isLoopback());
        socket.setReceiveBufferSize(this.connector.getBufferSize());
        socket.setSendBufferSize(this.connector.getBufferSize());
        socket.joinGroup(inetAddress);
        return socket;
    }

    protected void doDisconnect() throws Exception {
        try {
            if (this.socket != null) {
                ((MulticastSocket)this.socket).leaveGroup(this.inetAddress);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Failed to leave group: " + this.inetAddress));
        }
        super.doDisconnect();
    }
}

