/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.multicast;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.mule.providers.multicast.MulticastConnector;
import org.mule.providers.udp.UdpSocketFactory;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class MulticastSocketFactory
extends UdpSocketFactory {
    public Object makeObject(Object key) throws Exception {
        UMOImmutableEndpoint ep = (UMOImmutableEndpoint)key;
        MulticastSocket socket = (MulticastSocket)super.makeObject(key);
        socket.setLoopbackMode(((MulticastConnector)ep.getConnector()).isLoopback());
        int ttl = ((MulticastConnector)ep.getConnector()).getTimeToLive();
        if (ttl != -1) {
            socket.setTimeToLive(ttl);
        }
        return socket;
    }

    public void destroyObject(Object key, Object object) throws Exception {
        UMOImmutableEndpoint ep = (UMOImmutableEndpoint)key;
        String host = ep.getEndpointURI().getHost();
        InetAddress inetAddress = "null".equalsIgnoreCase(host) ? InetAddress.getLocalHost() : InetAddress.getByName(host);
        MulticastSocket socket = (MulticastSocket)object;
        socket.leaveGroup(inetAddress);
        super.destroyObject(key, object);
    }

    protected DatagramSocket createSocket() throws IOException {
        return new MulticastSocket();
    }

    protected DatagramSocket createSocket(int port) throws IOException {
        throw new IllegalArgumentException("A group host or IP address is required");
    }

    protected DatagramSocket createSocket(int port, InetAddress inetAddress) throws IOException {
        MulticastSocket socket = new MulticastSocket(port);
        socket.joinGroup(inetAddress);
        return socket;
    }
}

