/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.URI;
import javax.resource.spi.work.Work;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractConnector;
import org.mule.transport.udp.UdpMessageReceiver;

public class MulticastMessageReceiver
extends UdpMessageReceiver {
    public MulticastMessageReceiver(AbstractConnector connector, Service service, ImmutableEndpoint endpoint) throws CreateException {
        super((Connector)connector, service, endpoint);
    }

    protected DatagramSocket createSocket(URI uri, InetAddress inetAddress) throws IOException {
        MulticastSocket socket = new MulticastSocket(uri.getPort());
        socket.joinGroup(inetAddress);
        return socket;
    }

    protected Work createWork(DatagramPacket packet) throws IOException {
        return new MulticastWorker(packet);
    }

    protected void doDispose() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                ((MulticastSocket)this.socket).leaveGroup(this.inetAddress);
            }
            catch (IOException e) {
                this.logger.error((Object)("failed to leave group: " + e.getMessage()), (Throwable)e);
            }
        }
        super.doDispose();
    }

    public class MulticastWorker
    extends UdpMessageReceiver.UdpWorker {
        public MulticastWorker(DatagramPacket packet) {
            super((UdpMessageReceiver)MulticastMessageReceiver.this, MulticastMessageReceiver.this.socket, packet);
        }

        public void dispose() {
        }
    }
}

