/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.multicast;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.multicast.MulticastSocketFactory;
import org.mule.transport.udp.UdpConnector;

public class MulticastConnector
extends UdpConnector {
    public static final String MULTICAST = "multicast";
    private boolean loopback = false;
    private int timeToLive = -1;

    public String getProtocol() {
        return MULTICAST;
    }

    public MulticastConnector(MuleContext context) {
        super(context);
    }

    protected void doInitialise() throws InitialisationException {
        this.socketFactory = new MulticastSocketFactory();
        this.dispatcherSocketsPool.setFactory((KeyedPoolableObjectFactory)this.socketFactory);
        this.dispatcherSocketsPool.setTestOnBorrow(false);
        this.dispatcherSocketsPool.setTestOnReturn(true);
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public void setLoopback(boolean loopback) {
        this.loopback = loopback;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    protected Object getReceiverKey(FlowConstruct flowConstruct, InboundEndpoint endpoint) {
        return endpoint.getEndpointURI().getAddress() + "/" + flowConstruct.getName();
    }
}

