/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.multicast;

import java.net.DatagramPacket;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.multicast.MulticastConnector;

public class MulticastConnectorTestCase
extends AbstractConnectorTestCase {
    public Connector createConnector() throws Exception {
        MulticastConnector c = new MulticastConnector(muleContext);
        c.setName("MulticastConnector");
        return c;
    }

    public String getTestEndpointURI() {
        return "multicast://228.3.4.5:60106";
    }

    public Object getValidMessage() throws Exception {
        return new DatagramPacket("Hello".getBytes(), 5);
    }

    @Test
    public void testValidListener() throws Exception {
        Service service = MulticastConnectorTestCase.getTestService((String)"orange", Orange.class);
        Connector connector = this.getConnector();
        InboundEndpoint endpoint2 = muleContext.getEndpointFactory().getInboundEndpoint("multicast://228.2.3.4:10100");
        connector.registerListener(endpoint2, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        try {
            connector.registerListener(endpoint2, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
            Assert.fail((String)"cannot register on the same endpointUri");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testProperties() throws Exception {
        MulticastConnector c = new MulticastConnector(muleContext);
        c.setReceiveBufferSize(1024);
        Assert.assertEquals((long)1024L, (long)c.getReceiveBufferSize());
        c.setReceiveBufferSize(0);
        Assert.assertEquals((long)16384L, (long)c.getReceiveBufferSize());
        c.setTimeout(-1);
        Assert.assertEquals((long)-1L, (long)c.getTimeout());
        c.setLoopback(true);
        Assert.assertTrue((boolean)c.isLoopback());
    }
}

