/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.multicast;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastConnectorFunctionalTestCase
extends FunctionalTestCase {
    public static final String MESSAGE = "hello";
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastConnectorFunctionalTestCase.class);

    protected String getConfigFile() {
        return "multicast-functional-test.xml";
    }

    @Test
    public void testSendTestData() throws Exception {
        int receivedPackets;
        int numberOfMessages = 2;
        LocalMuleClient client = muleContext.getClient();
        LOGGER.debug("sending messages");
        for (int sentPackets = 0; sentPackets < 2; ++sentPackets) {
            String msg = MESSAGE + sentPackets;
            client.dispatch("serverEndpoint", (Object)msg, null);
        }
        int broadcastMessages = 6;
        HashSet<String> receivedMessages = new HashSet<String>(broadcastMessages);
        LOGGER.debug("receiving messages");
        for (receivedPackets = 0; receivedPackets < broadcastMessages; ++receivedPackets) {
            MuleMessage message = client.request("vm://foo", 2000L);
            Assert.assertNotNull((Object)message);
            receivedMessages.add(message.getPayloadAsString());
        }
        Assert.assertEquals((long)broadcastMessages, (long)receivedPackets);
        this.checkBroadcastMessagesForComponent(2, receivedMessages, "Component1");
        this.checkBroadcastMessagesForComponent(2, receivedMessages, "Component2");
        this.checkBroadcastMessagesForComponent(2, receivedMessages, "Component3");
        Assert.assertEquals((long)0L, (long)receivedMessages.size());
    }

    protected void checkBroadcastMessagesForComponent(int numberOfMessages, Set<String> receivedMessages, String componentName) {
        for (int x = 0; x < numberOfMessages; ++x) {
            String expected = MESSAGE + x + componentName;
            Assert.assertTrue((boolean)receivedMessages.contains(expected));
            Assert.assertTrue((boolean)receivedMessages.remove(expected));
        }
    }
}

