/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz;

import java.util.Date;
import org.mule.RegistryContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.DelegatingJob;
import org.mule.util.ClassUtils;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzMessageDispatcher
extends AbstractMessageDispatcher {
    public QuartzMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    protected void doDispose() {
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(event.getEndpoint().getEndpointURI().toString() + "-" + event.getId());
        JobDataMap jobDataMap = new JobDataMap();
        MuleMessage msg = event.getMessage();
        for (String propertyKey : msg.getPropertyNames()) {
            jobDataMap.put((Object)propertyKey, msg.getProperty(propertyKey));
        }
        jobDetail.setJobDataMap(jobDataMap);
        Object payload = event.transformMessage();
        String jobClass = jobDataMap.getString("jobClass");
        if (payload instanceof Job) {
            Job job = (Job)payload;
            jobDataMap.put((Object)"jobObject", (Object)job);
            jobDetail.setJobClass(DelegatingJob.class);
        } else if (jobClass != null) {
            jobDetail.setJobClass(ClassUtils.loadClass((String)jobClass, ((Object)((Object)this)).getClass()));
        } else {
            Object tempJob = jobDataMap.get((Object)"jobObject");
            if (tempJob == null) {
                tempJob = jobDataMap.get((Object)"jobRef");
                if (tempJob == null) {
                    throw new DispatchException(QuartzMessages.invalidPayloadType(), event.getMessage(), event.getEndpoint());
                }
                tempJob = RegistryContext.getRegistry().lookupObject((String)tempJob);
                if (!(tempJob instanceof Job)) {
                    throw new DispatchException(QuartzMessages.invalidJobObject(), event.getMessage(), event.getEndpoint());
                }
            } else if (!(tempJob instanceof Job)) {
                throw new DispatchException(QuartzMessages.invalidJobObject(), event.getMessage(), event.getEndpoint());
            }
            jobDetail.setJobClass(DelegatingJob.class);
        }
        jobDataMap.put((Object)"payload", payload);
        CronTrigger trigger = null;
        String cronExpression = jobDataMap.getString("cronExpression");
        String repeatInterval = jobDataMap.getString("repeatInterval");
        String repeatCount = jobDataMap.getString("repeatCount");
        String startDelay = jobDataMap.getString("startDelay");
        String groupName = jobDataMap.getString("groupName");
        String jobGroupName = jobDataMap.getString("jobGroupName");
        if (groupName == null) {
            groupName = "mule";
        }
        if (jobGroupName == null) {
            jobGroupName = groupName;
        }
        jobDetail.setGroup(groupName);
        if (cronExpression != null) {
            CronTrigger ctrigger = new CronTrigger();
            ctrigger.setCronExpression(cronExpression);
            trigger = ctrigger;
        } else if (repeatInterval != null) {
            SimpleTrigger strigger = new SimpleTrigger();
            strigger.setRepeatInterval(Long.parseLong(repeatInterval));
            if (repeatCount != null) {
                strigger.setRepeatCount(Integer.parseInt(repeatCount));
            } else {
                strigger.setRepeatCount(-1);
            }
            trigger = strigger;
        } else {
            throw new IllegalArgumentException(QuartzMessages.cronExpressionOrIntervalMustBeSet().getMessage());
        }
        long start = System.currentTimeMillis();
        if (startDelay != null) {
            start += Long.parseLong(startDelay);
        }
        trigger.setStartTime(new Date(start));
        trigger.setName(event.getEndpoint().getEndpointURI().toString() + "-" + event.getId());
        trigger.setGroup(groupName);
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobGroupName);
        Scheduler scheduler = ((QuartzConnector)this.getConnector()).getQuartzScheduler();
        scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return null;
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

