/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz;

import java.util.Date;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.MuleReceiverJob;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzMessageReceiver
extends AbstractMessageReceiver {
    public static final String QUARTZ_RECEIVER_PROPERTY = "mule.quartz.receiver";
    public static final String QUARTZ_CONNECTOR_PROPERTY = "mule.quartz.connector";
    private final QuartzConnector connector;

    public QuartzMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        this.connector = (QuartzConnector)connector;
    }

    protected void doDispose() {
    }

    protected void doStart() throws MuleException {
        try {
            Scheduler scheduler = this.connector.getQuartzScheduler();
            JobDetail jobDetail = new JobDetail();
            jobDetail.setName(this.endpoint.getEndpointURI().toString());
            jobDetail.setJobClass(MuleReceiverJob.class);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put(QUARTZ_RECEIVER_PROPERTY, this.getReceiverKey());
            jobDataMap.put(QUARTZ_CONNECTOR_PROPERTY, this.connector.getName());
            jobDataMap.putAll(this.endpoint.getProperties());
            jobDetail.setJobDataMap(jobDataMap);
            CronTrigger trigger = null;
            String cronExpression = jobDataMap.getString("cronExpression");
            String repeatInterval = jobDataMap.getString("repeatInterval");
            String repeatCount = jobDataMap.getString("repeatCount");
            String startDelay = jobDataMap.getString("startDelay");
            String groupName = jobDataMap.getString("groupName");
            String jobGroupName = jobDataMap.getString("jobGroupName");
            if (groupName == null) {
                groupName = "mule";
            }
            if (jobGroupName == null) {
                jobGroupName = groupName;
            }
            jobDetail.setGroup(groupName);
            if (cronExpression != null) {
                CronTrigger ctrigger = new CronTrigger();
                ctrigger.setCronExpression(cronExpression);
                trigger = ctrigger;
            } else if (repeatInterval != null) {
                SimpleTrigger strigger = new SimpleTrigger();
                strigger.setRepeatInterval(Long.parseLong(repeatInterval));
                if (repeatCount != null) {
                    strigger.setRepeatCount(Integer.parseInt(repeatCount));
                } else {
                    strigger.setRepeatCount(-1);
                }
                trigger = strigger;
            } else {
                throw new IllegalArgumentException(QuartzMessages.cronExpressionOrIntervalMustBeSet().getMessage());
            }
            long start = System.currentTimeMillis();
            if (startDelay != null) {
                start += Long.parseLong(startDelay);
            }
            trigger.setStartTime(new Date(start));
            trigger.setName(this.endpoint.getEndpointURI().toString());
            trigger.setGroup(groupName);
            trigger.setJobName(this.endpoint.getEndpointURI().toString());
            trigger.setJobGroup(jobGroupName);
            try {
                scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
            catch (ObjectAlreadyExistsException oaee) {
                // empty catch block
            }
            scheduler.start();
        }
        catch (Exception e) {
            throw new EndpointException(CoreMessages.failedToStart((String)"Quartz receiver"), (Throwable)e);
        }
    }

    protected void doStop() throws MuleException {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

