/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.module.client.MuleClient;
import org.mule.transport.NullPayload;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MuleClientDispatchJob
implements Job {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String dispatchEndpoint;
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Object payload = jobDataMap.get((Object)"payload");
        if (payload == null) {
            payload = NullPayload.getInstance();
        }
        if ((dispatchEndpoint = jobDataMap.getString("jobDispatchEndpoint")) == null) {
            throw new JobExecutionException(QuartzMessages.missingJobDetail("jobDispatchEndpoint").getMessage());
        }
        try {
            MuleClient client = new MuleClient();
            this.logger.debug((Object)("Dispatching payload on: " + dispatchEndpoint));
            client.dispatch(dispatchEndpoint, payload, (Map)jobDataMap);
        }
        catch (MuleException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

