/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MuleClientReceiveJob
implements Job {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        String dispatchEndpoint = jobDataMap.getString("jobDispatchEndpoint");
        if (dispatchEndpoint == null) {
            throw new JobExecutionException(QuartzMessages.missingJobDetail("jobDispatchEndpoint").getMessage());
        }
        String receiveEndpoint = jobDataMap.getString("jobReceiveEndpoint");
        if (receiveEndpoint == null) {
            throw new JobExecutionException(QuartzMessages.missingJobDetail("jobReceiveEndpoint").getMessage());
        }
        long timeout = 5000L;
        String timeoutString = jobDataMap.getString("jobReceiveTimeout");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        try {
            MuleClient client = new MuleClient();
            this.logger.debug((Object)("Attempting to receive event on: " + receiveEndpoint));
            MuleMessage result = client.request(receiveEndpoint, timeout);
            if (result != null) {
                this.logger.debug((Object)("Received event on: " + receiveEndpoint));
                this.logger.debug((Object)("Dispatching result on: " + dispatchEndpoint));
                result.addProperties((Map)jobDataMap);
                client.dispatch(dispatchEndpoint, result);
            }
        }
        catch (MuleException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

