/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.config;

import org.mule.config.spring.factories.InboundEndpointFactoryBean;
import org.mule.config.spring.factories.OutboundEndpointFactoryBean;
import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.collection.ChildMapDefinitionParser;
import org.mule.config.spring.parsers.collection.ChildSingletonMapDefinitionParser;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.config.spring.parsers.generic.ParentDefinitionParser;
import org.mule.config.spring.parsers.specific.DataObjectDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.EndpointPropertyElementDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.EndpointRefParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportEndpointDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.TransportGlobalEndpointDefinitionParser;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.jobs.CustomJobConfig;
import org.mule.transport.quartz.jobs.CustomJobFromMessageConfig;
import org.mule.transport.quartz.jobs.EndpointPollingJobConfig;
import org.mule.transport.quartz.jobs.EventGeneratorJobConfig;
import org.mule.transport.quartz.jobs.ScheduledDispatchJobConfig;
import org.springframework.beans.factory.xml.BeanDefinitionParser;

public class QuartzNamespaceHandler
extends AbstractMuleNamespaceHandler {
    public static final String JOB_NAME_ATTRIBUTE = "jobName";
    public static final String[][] QUARTZ_ATTRIBUTES = new String[][]{{"jobName"}};

    public void init() {
        this.registerQuartzTransportEndpoints();
        this.registerMuleBeanDefinitionParser("connector", (MuleDefinitionParser)new MuleOrphanDefinitionParser(QuartzConnector.class, true)).addAlias("scheduler", "quartzScheduler");
        this.registerBeanDefinitionParser("factory-property", (BeanDefinitionParser)new ChildSingletonMapDefinitionParser("factoryProperty"));
        this.registerBeanDefinitionParser("factory-properties", (BeanDefinitionParser)new ChildMapDefinitionParser("factoryProperty"));
        this.registerBeanDefinitionParser("event-generator-job", (BeanDefinitionParser)new EndpointPropertyElementDefinitionParser("jobConfig", EventGeneratorJobConfig.class));
        this.registerBeanDefinitionParser("endpoint-polling-job", (BeanDefinitionParser)new EndpointPropertyElementDefinitionParser("jobConfig", EndpointPollingJobConfig.class));
        this.registerBeanDefinitionParser("scheduled-dispatch-job", (BeanDefinitionParser)new EndpointPropertyElementDefinitionParser("jobConfig", ScheduledDispatchJobConfig.class));
        this.registerBeanDefinitionParser("custom-job", (BeanDefinitionParser)new EndpointPropertyElementDefinitionParser("jobConfig", CustomJobConfig.class));
        this.registerBeanDefinitionParser("custom-job-from-message", (BeanDefinitionParser)new EndpointPropertyElementDefinitionParser("jobConfig", CustomJobFromMessageConfig.class));
        ParentDefinitionParser parser = new ParentDefinitionParser();
        parser.addAlias("address", "endpointRef");
        parser.addAlias("ref", "endpointRef");
        this.registerBeanDefinitionParser("job-endpoint", (BeanDefinitionParser)new EndpointRefParser("endpointRef"));
        this.registerBeanDefinitionParser("payload", (BeanDefinitionParser)new DataObjectDefinitionParser("payload"));
    }

    protected void registerQuartzTransportEndpoints() {
        this.registerQuartzEndpointDefinitionParser("endpoint", (MuleDefinitionParser)new TransportGlobalEndpointDefinitionParser("quartz", false, TransportGlobalEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, QUARTZ_ATTRIBUTES, (String[][])new String[0][]));
        this.registerQuartzEndpointDefinitionParser("inbound-endpoint", (MuleDefinitionParser)new TransportEndpointDefinitionParser("quartz", false, InboundEndpointFactoryBean.class, TransportEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, QUARTZ_ATTRIBUTES, (String[][])new String[0][]));
        this.registerQuartzEndpointDefinitionParser("outbound-endpoint", (MuleDefinitionParser)new TransportEndpointDefinitionParser("quartz", false, OutboundEndpointFactoryBean.class, TransportEndpointDefinitionParser.RESTRICTED_ENDPOINT_ATTRIBUTES, QUARTZ_ATTRIBUTES, (String[][])new String[0][]));
    }

    protected void registerQuartzEndpointDefinitionParser(String element, MuleDefinitionParser parser) {
        parser.addAlias(JOB_NAME_ATTRIBUTE, "path");
        this.registerBeanDefinitionParser(element, (BeanDefinitionParser)parser);
    }
}

