/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.lang.reflect.InvocationTargetException;
import org.mule.api.MuleMessage;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.quartz.config.AbstractJobConfig;
import org.mule.transport.quartz.config.JobConfig;
import org.mule.transport.quartz.jobs.CustomJob;
import org.mule.transport.quartz.jobs.CustomJobConfig;
import org.mule.util.ClassUtils;
import org.mule.util.expression.ExpressionEvaluatorManager;
import org.quartz.Job;

public class CustomJobFromMessageConfig
extends AbstractJobConfig {
    private String expression;
    private String evaluator;
    private String customEvaluator;

    public Job getJob(MuleMessage message) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        Object result;
        if (this.evaluator.equals("custom")) {
            this.evaluator = this.customEvaluator;
        }
        if ((result = ExpressionEvaluatorManager.evaluate((String)this.expression, (String)this.evaluator, (Object)message, (boolean)true)) instanceof Job) {
            return (Job)result;
        }
        if (!(result instanceof JobConfig)) {
            throw new IllegalStateException(CoreMessages.propertyIsNotSupportedType((String)(this.evaluator + ":" + this.expression), (Class[])new Class[]{Job.class, JobConfig.class}, result.getClass()).getMessage());
        }
        Class clazz = ((JobConfig)result).getJobClass();
        return (Job)ClassUtils.instanciateClass((Class)clazz, (Object[])ClassUtils.NO_ARGS);
    }

    public JobConfig getJobConfig(MuleMessage message) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        Object result;
        if (this.evaluator.equals("custom")) {
            this.evaluator = this.customEvaluator;
        }
        if ((result = ExpressionEvaluatorManager.evaluate((String)this.expression, (String)this.evaluator, (Object)message, (boolean)true)) instanceof Job) {
            CustomJobConfig customJob = new CustomJobConfig();
            customJob.setJob((Job)result);
            return customJob;
        }
        if (result instanceof JobConfig) {
            return (JobConfig)result;
        }
        throw new IllegalStateException(CoreMessages.propertyIsNotSupportedType((String)(this.evaluator + ":" + this.expression), (Class[])new Class[]{Job.class, JobConfig.class, Class.class, String.class}, result.getClass()).getMessage());
    }

    public String getCustomEvaluator() {
        return this.customEvaluator;
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.customEvaluator = customEvaluator;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = evaluator;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Class getJobClass() {
        return CustomJob.class;
    }
}

