/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.PropertyScope;
import org.mule.module.client.MuleClient;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.EndpointPollingJobConfig;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EndpointPollingJob
implements Job {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        String receiverKey = (String)jobDataMap.get((Object)"mule.quartz.receiver");
        if (receiverKey == null) {
            throw new JobExecutionException(QuartzMessages.receiverNotInJobDataMap().getMessage());
        }
        String connectorName = (String)jobDataMap.get((Object)"mule.quartz.connector");
        if (connectorName == null) {
            throw new JobExecutionException(QuartzMessages.connectorNotInJobDataMap().getMessage());
        }
        AbstractConnector connector = (AbstractConnector)RegistryContext.getRegistry().lookupConnector(connectorName);
        if (connector == null) {
            throw new JobExecutionException(QuartzMessages.noConnectorFound(connectorName).getMessage());
        }
        AbstractMessageReceiver receiver = (AbstractMessageReceiver)connector.lookupReceiver(receiverKey);
        if (receiver == null) {
            throw new JobExecutionException(QuartzMessages.noReceiverInConnector(receiverKey, connectorName).getMessage());
        }
        EndpointPollingJobConfig jobConfig = (EndpointPollingJobConfig)jobDataMap.get((Object)"jobConfig");
        if (jobConfig == null) {
            throw new JobExecutionException(QuartzMessages.missingJobDetail("jobConfig").getMessage());
        }
        try {
            MuleClient client = new MuleClient();
            this.logger.debug((Object)("Attempting to receive event on: " + jobConfig.getEndpointRef()));
            MuleMessage result = client.request(jobConfig.getEndpointRef(), (long)jobConfig.getTimeout());
            if (result != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received event on: " + jobConfig.getEndpointRef()));
                }
                result = (MuleMessage)((ThreadSafeAccess)result).newThreadCopy();
                result.addProperties((Map)jobDataMap, PropertyScope.INVOCATION);
                receiver.routeMessage(result);
            }
        }
        catch (MuleException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

