/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.NullPayload;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;

public class EventGeneratorJob
implements Job {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        MuleContext muleContext;
        try {
            muleContext = (MuleContext)jobExecutionContext.getScheduler().getContext().get((Object)"mule.context");
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to retrieve Mulecontext from the Scheduler Context: " + e.getMessage(), (Throwable)e);
        }
        JobDataMap map = jobExecutionContext.getJobDetail().getJobDataMap();
        String receiverKey = (String)map.get((Object)"mule.quartz.receiver");
        if (receiverKey == null) {
            throw new JobExecutionException(QuartzMessages.receiverNotInJobDataMap().getMessage());
        }
        String connectorName = (String)map.get((Object)"mule.quartz.connector");
        if (connectorName == null) {
            throw new JobExecutionException(QuartzMessages.connectorNotInJobDataMap().getMessage());
        }
        AbstractConnector connector = (AbstractConnector)muleContext.getRegistry().lookupConnector(connectorName);
        if (connector == null) {
            throw new JobExecutionException(QuartzMessages.noConnectorFound(connectorName).getMessage());
        }
        AbstractMessageReceiver receiver = (AbstractMessageReceiver)connector.lookupReceiver(receiverKey);
        if (receiver == null) {
            throw new JobExecutionException(QuartzMessages.noReceiverInConnector(receiverKey, connectorName).getMessage());
        }
        Object payload = jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"payload");
        try {
            String ref;
            if (payload == null && (payload = (ref = jobExecutionContext.getJobDetail().getJobDataMap().getString("payload")) == null ? NullPayload.getInstance() : muleContext.getRegistry().lookupObject(ref)) == null) {
                this.logger.warn((Object)"There is no payload attached to this quartz job. Sending Null payload");
                payload = NullPayload.getInstance();
            }
            DefaultMuleMessage msg = new DefaultMuleMessage((Object)receiver.getConnector().getMessageAdapter(payload), muleContext);
            msg.setProperty("jobData", (Object)jobExecutionContext.getJobDetail().getJobDataMap(), PropertyScope.INVOCATION);
            receiver.routeMessage((MuleMessage)msg);
        }
        catch (Exception e) {
            receiver.handleException(e);
        }
    }
}

