/*
 * $Id: StatefulEventGeneratorJob.java 15939 2009-11-03 11:25:38Z rossmason $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.transport.quartz.jobs;

import org.quartz.StatefulJob;

/**
 * Same as {@link org.mule.transport.quartz.jobs.EventGeneratorJob} except the JobDetail state is persistent
 * for each request and only one instance of the job will fire  at any given trigger. If the job does not
 * complete before the next trigger the second execution is blocked until the job completes
 */
public class StatefulEventGeneratorJob extends EventGeneratorJob implements StatefulJob
{
}
