/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz;

import java.util.Date;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.config.JobConfig;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.CustomJobConfig;
import org.mule.transport.quartz.jobs.EventGeneratorJobConfig;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzMessageReceiver
extends AbstractMessageReceiver {
    public static final String QUARTZ_RECEIVER_PROPERTY = "mule.quartz.receiver";
    public static final String QUARTZ_CONNECTOR_PROPERTY = "mule.quartz.connector";
    private final QuartzConnector connector;

    public QuartzMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, service, endpoint);
        this.connector = (QuartzConnector)connector;
    }

    protected void doDispose() {
    }

    protected void doStart() throws MuleException {
        try {
            CronTrigger trigger;
            Scheduler scheduler = this.connector.getQuartzScheduler();
            JobConfig jobConfig = (JobConfig)this.endpoint.getProperty((Object)"jobConfig");
            if (jobConfig == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"jobConfig").getMessage());
            }
            JobDetail jobDetail = new JobDetail();
            jobDetail.setName(this.endpoint.getEndpointURI().getAddress());
            jobDetail.setJobClass(jobConfig.getJobClass());
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put(QUARTZ_RECEIVER_PROPERTY, this.getReceiverKey());
            jobDataMap.put(QUARTZ_CONNECTOR_PROPERTY, this.connector.getName());
            jobDataMap.putAll(this.endpoint.getProperties());
            if (jobConfig instanceof EventGeneratorJobConfig) {
                jobDataMap.put((Object)"payload", ((EventGeneratorJobConfig)jobConfig).getPayload());
            }
            jobDataMap.put((Object)"jobConfig", (Object)jobConfig);
            Job job = null;
            if (jobConfig instanceof CustomJobConfig) {
                job = ((CustomJobConfig)jobConfig).getJob();
            }
            if (job != null) {
                jobDataMap.put((Object)"jobObject", (Object)job);
                jobDetail.setJobClass(jobConfig.getJobClass());
            }
            jobDetail.setJobDataMap(jobDataMap);
            String cronExpression = (String)this.endpoint.getProperty((Object)"cronExpression");
            String repeatInterval = (String)this.endpoint.getProperty((Object)"repeatInterval");
            String repeatCount = (String)this.endpoint.getProperty((Object)"repeatCount");
            String startDelay = (String)this.endpoint.getProperty((Object)"startDelay");
            String groupName = jobConfig.getGroupName();
            String jobGroupName = jobConfig.getJobGroupName();
            if (groupName == null) {
                groupName = "mule";
            }
            if (jobGroupName == null) {
                jobGroupName = groupName;
            }
            jobDetail.setGroup(groupName);
            if (cronExpression != null) {
                CronTrigger ctrigger = new CronTrigger();
                ctrigger.setCronExpression(cronExpression);
                trigger = ctrigger;
            } else if (repeatInterval != null) {
                SimpleTrigger strigger = new SimpleTrigger();
                strigger.setRepeatInterval(Long.parseLong(repeatInterval));
                if (repeatCount != null) {
                    strigger.setRepeatCount(Integer.parseInt(repeatCount));
                } else {
                    strigger.setRepeatCount(-1);
                }
                trigger = strigger;
            } else {
                throw new IllegalArgumentException(QuartzMessages.cronExpressionOrIntervalMustBeSet().getMessage());
            }
            long start = System.currentTimeMillis();
            if (startDelay != null) {
                start += Long.parseLong(startDelay);
            }
            trigger.setStartTime(new Date(start));
            trigger.setName(this.endpoint.getEndpointURI().getAddress());
            trigger.setGroup(groupName);
            trigger.setJobName(this.endpoint.getEndpointURI().getAddress());
            trigger.setJobGroup(jobGroupName);
            try {
                scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
            catch (ObjectAlreadyExistsException oaee) {
                this.logger.warn((Object)("A quartz Job with name: " + this.endpoint.getEndpointURI().getAddress() + " has already been registered. Cannot register again"));
            }
            scheduler.start();
        }
        catch (Exception e) {
            throw new EndpointException(CoreMessages.failedToStart((String)"Quartz receiver"), (Throwable)e);
        }
    }

    protected void doStop() throws MuleException {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

