/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import org.mule.api.MuleContext;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;

public class CustomJob
implements Job {
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        MuleContext muleContext = this.lookupMuleContext(jobExecutionContext);
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Object tempJob = jobDataMap.get((Object)"jobObject");
        if (tempJob == null) {
            tempJob = jobDataMap.get((Object)"jobRef");
            if (tempJob == null) {
                throw new JobExecutionException(QuartzMessages.invalidPayloadType().getMessage());
            }
            tempJob = muleContext.getRegistry().lookupObject((String)tempJob);
            if (tempJob == null) {
                throw new JobExecutionException("Job not found: " + tempJob);
            }
            if (!(tempJob instanceof Job)) {
                throw new JobExecutionException(QuartzMessages.invalidJobObject().getMessage());
            }
        } else if (!(tempJob instanceof Job)) {
            throw new JobExecutionException(QuartzMessages.invalidJobObject().toString());
        }
        ((Job)tempJob).execute(jobExecutionContext);
    }

    private MuleContext lookupMuleContext(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            SchedulerContext schedulerContext = jobExecutionContext.getScheduler().getContext();
            return (MuleContext)schedulerContext.get((Object)"mule.context");
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to retrieve Mulecontext from the Scheduler Context: " + e.getMessage(), (Throwable)e);
        }
    }
}

