/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.lang.reflect.InvocationTargetException;
import org.mule.api.MuleMessage;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.quartz.config.AbstractJobConfig;
import org.mule.transport.quartz.config.JobConfig;
import org.mule.transport.quartz.jobs.CustomJob;
import org.mule.transport.quartz.jobs.CustomJobConfig;
import org.mule.transport.quartz.jobs.StatefulCustomJob;
import org.mule.util.ClassUtils;
import org.quartz.Job;
import org.quartz.StatefulJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomJobFromMessageConfig
extends AbstractJobConfig {
    private String expression;
    private String evaluator;
    private String customEvaluator;

    public Job getJob(MuleMessage message) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        Object result;
        if (this.evaluator.equals("custom")) {
            this.evaluator = this.customEvaluator;
        }
        if ((result = this.getMuleContext().getExpressionManager().evaluate(this.expression, this.evaluator, message, true)) instanceof Job) {
            return (Job)result;
        }
        if (!(result instanceof JobConfig)) {
            throw new IllegalStateException(CoreMessages.propertyIsNotSupportedType((String)(this.evaluator + ":" + this.expression), (Class[])new Class[]{Job.class, JobConfig.class}, result.getClass()).getMessage());
        }
        Class<? extends Job> clazz = ((JobConfig)result).getJobClass();
        return (Job)ClassUtils.instanciateClass(clazz, (Object[])new Object[0]);
    }

    public JobConfig getJobConfig(MuleMessage message) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        Object result;
        if (this.evaluator.equals("custom")) {
            this.evaluator = this.customEvaluator;
        }
        if ((result = this.getMuleContext().getExpressionManager().evaluate(this.expression, this.evaluator, message, true)) instanceof Job) {
            CustomJobConfig customJob = new CustomJobConfig();
            customJob.setJob((Job)result);
            return customJob;
        }
        if (result instanceof JobConfig) {
            return (JobConfig)result;
        }
        throw new IllegalStateException(CoreMessages.propertyIsNotSupportedType((String)(this.evaluator + ":" + this.expression), (Class[])new Class[]{Job.class, JobConfig.class, Class.class, String.class}, result.getClass()).getMessage());
    }

    public String getCustomEvaluator() {
        return this.customEvaluator;
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.customEvaluator = customEvaluator;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = evaluator;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    protected Class<? extends StatefulJob> getStatefulJobClass() {
        return StatefulCustomJob.class;
    }

    @Override
    protected Class<? extends Job> getStatelessJobClass() {
        return CustomJob.class;
    }
}

