/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import java.lang.reflect.Method;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.rmi.RmiConnector;
import org.mule.transport.rmi.i18n.RmiMessages;
import org.mule.util.ClassUtils;

public class RmiMessageReceiver
extends AbstractPollingMessageReceiver {
    protected RmiConnector connector;
    protected Remote remoteObject;
    protected Method invokeMethod;
    protected Object[] methodArguments = null;

    public RmiMessageReceiver(Connector connector, Service service, Endpoint endpoint, long frequency) throws CreateException {
        super(connector, service, (ImmutableEndpoint)endpoint);
        this.setFrequency(frequency);
        this.connector = (RmiConnector)connector;
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        String methodName;
        System.setProperty("java.security.policy", this.connector.getSecurityPolicy());
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        if (null == (methodName = MapUtils.getString((Map)this.endpoint.getEndpointURI().getParams(), (Object)"method", null)) && null == (methodName = (String)this.endpoint.getProperty((Object)"method"))) {
            throw new ConnectException(RmiMessages.messageParamServiceMethodNotSet(), (Connectable)this);
        }
        this.remoteObject = this.connector.getRemoteObject(this.getEndpoint());
        List args = (List)this.endpoint.getProperty((Object)"methodArgumentsList");
        Class[] argTypes = new Class[]{};
        if (args == null) {
            this.logger.info((Object)"methodArgumentsList not set on endpoint, assuming method call has no arguments");
            this.methodArguments = ClassUtils.NO_ARGS;
        } else {
            argTypes = ClassUtils.getClassTypes((Object)this.methodArguments);
            this.methodArguments = new Object[args.size()];
            this.methodArguments = args.toArray(this.methodArguments);
        }
        this.invokeMethod = this.remoteObject.getClass().getMethod(methodName, argTypes);
    }

    protected void doDisconnect() {
        this.invokeMethod = null;
        this.remoteObject = null;
    }

    public void poll() {
        try {
            Object result = this.invokeMethod.invoke((Object)this.remoteObject, this.getMethodArguments());
            if (null != result) {
                Object payload = this.connector.getMessageAdapter(result).getPayload();
                this.routeMessage((MuleMessage)new DefaultMuleMessage(payload), this.endpoint.isSynchronous());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected Object[] getMethodArguments() {
        return this.methodArguments;
    }
}

