/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.HashMap;
import org.mule.api.MuleMessage;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.Message;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.rmi.i18n.RmiMessages;

public abstract class AbstractFunctionalTestCase
extends FunctionalTestCase {
    private String prefix;
    private String config;

    public AbstractFunctionalTestCase(String prefix, String config) {
        this.prefix = prefix;
        this.config = config;
    }

    public void testCase() throws Exception {
        MuleClient client = new MuleClient();
        MuleMessage message = client.send("vm://testin", (Object)new Integer(12), null);
        AbstractFunctionalTestCase.assertNotNull((Object)message);
        Integer payload = (Integer)message.getPayload();
        AbstractFunctionalTestCase.assertEquals((Object)payload, (Object)new Integer(22));
        message = client.send("vm://testin", (Object)"test matching component first time", null);
        AbstractFunctionalTestCase.assertNotNull((Object)message);
        AbstractFunctionalTestCase.assertEquals((String)((String)message.getPayload()), (String)"emit tsrif tnenopmoc gnihctam tset");
        message = client.send("vm://testin", (Object)"test mathching component second time", null);
        AbstractFunctionalTestCase.assertNotNull((Object)message);
        AbstractFunctionalTestCase.assertEquals((String)((String)message.getPayload()), (String)"emit dnoces tnenopmoc gnihchtam tset");
        message = client.send("vm://testin", (Object)new Integer(15), null);
        AbstractFunctionalTestCase.assertNotNull((Object)message);
        payload = (Integer)message.getPayload();
        AbstractFunctionalTestCase.assertEquals((Object)payload, (Object)new Integer(25));
    }

    private MuleMessage send(String uri, String message) throws Exception {
        MuleClient client = new MuleClient();
        return client.send(this.prefix + uri, (Object)message, new HashMap());
    }

    public void testReverseString() throws Exception {
        MuleMessage message = this.send("://localhost/TestService?method=reverseString", "hello");
        AbstractFunctionalTestCase.assertNotNull((Object)message.getPayload());
        AbstractFunctionalTestCase.assertEquals((String)"olleh", (String)message.getPayloadAsString());
    }

    public void testUpperCaseString() throws Exception {
        MuleMessage message = this.send("://localhost/TestService?method=upperCaseString", "hello");
        AbstractFunctionalTestCase.assertNotNull((Object)message.getPayload());
        AbstractFunctionalTestCase.assertEquals((String)"HELLO", (String)message.getPayloadAsString());
    }

    public void testNoMethodSet() throws Exception {
        try {
            this.send("://localhost/TestService", "hello");
        }
        catch (Exception e) {
            AbstractFunctionalTestCase.assertTrue((boolean)(e instanceof DispatchException));
            Message message = RmiMessages.messageParamServiceMethodNotSet();
            AbstractFunctionalTestCase.assertTrue((boolean)e.getMessage().startsWith(message.toString()));
        }
    }

    public void testBadMethodName() throws Exception {
        try {
            this.send("://localhost/TestService?method=foo", "hello");
            AbstractFunctionalTestCase.fail((String)"expected error");
        }
        catch (Exception e) {
            AbstractFunctionalTestCase.assertTrue((boolean)(e instanceof DispatchException));
            AbstractFunctionalTestCase.assertTrue((boolean)(e.getCause() instanceof NoSuchMethodException));
        }
    }

    protected String getConfigResources() {
        return this.config;
    }

    public void testBadMethodType() throws Exception {
        try {
            new MuleClient().send("BadType", (Object)"hello", null);
            AbstractFunctionalTestCase.fail((String)"expected error");
        }
        catch (Exception e) {
            AbstractFunctionalTestCase.assertTrue((boolean)(e instanceof DispatchException));
            AbstractFunctionalTestCase.assertTrue((boolean)(e.getCause() instanceof NoSuchMethodException));
        }
    }

    public void testCorrectMethodType() throws Exception {
        MuleMessage message = new MuleClient().send("GoodType", (Object)"hello", null);
        AbstractFunctionalTestCase.assertNotNull((Object)message);
        AbstractFunctionalTestCase.assertEquals((String)"olleh", (String)message.getPayloadAsString());
    }
}

