/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jnp;

import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.AbstractMuleTestCase;

public class JnpEndpointTestCase
extends AbstractMuleTestCase {
    public void testHostPortUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jnp://localhost:1099", muleContext);
        url.initialise();
        JnpEndpointTestCase.assertEquals((String)"jnp", (String)url.getScheme());
        JnpEndpointTestCase.assertEquals((String)"jnp://localhost:1099", (String)url.getAddress());
        JnpEndpointTestCase.assertNull((Object)url.getEndpointName());
        JnpEndpointTestCase.assertEquals((int)1099, (int)url.getPort());
        JnpEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        JnpEndpointTestCase.assertEquals((String)"jnp://localhost:1099", (String)url.getAddress());
        JnpEndpointTestCase.assertEquals((int)0, (int)url.getParams().size());
    }

    public void testQueryParams1() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jnp://localhost:1099/BeeShirtsjnpServer?method=testMethod", muleContext);
        url.initialise();
        JnpEndpointTestCase.assertEquals((String)"jnp", (String)url.getScheme());
        JnpEndpointTestCase.assertEquals((String)"jnp://localhost:1099", (String)url.getAddress());
        JnpEndpointTestCase.assertEquals((String)"/BeeShirtsjnpServer", (String)url.getPath());
        JnpEndpointTestCase.assertNull((Object)url.getEndpointName());
        JnpEndpointTestCase.assertEquals((int)1099, (int)url.getPort());
        JnpEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        JnpEndpointTestCase.assertEquals((String)"jnp://localhost:1099/BeeShirtsjnpServer?method=testMethod", (String)url.toString());
        JnpEndpointTestCase.assertEquals((int)1, (int)url.getParams().size());
        JnpEndpointTestCase.assertEquals((String)"testMethod", (String)url.getParams().getProperty("method"));
    }

    public void testQueryParams2() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jnp://localhost:1099/BeeShirtsjnpServer?method=testMethod&endpointName=jnpProvider&blankParam=", muleContext);
        url.initialise();
        JnpEndpointTestCase.assertEquals((String)"jnp", (String)url.getScheme());
        JnpEndpointTestCase.assertEquals((String)"jnp://localhost:1099", (String)url.getAddress());
        JnpEndpointTestCase.assertEquals((String)"/BeeShirtsjnpServer", (String)url.getPath());
        JnpEndpointTestCase.assertNotNull((Object)url.getEndpointName());
        JnpEndpointTestCase.assertEquals((String)"jnpProvider", (String)url.getEndpointName());
        JnpEndpointTestCase.assertEquals((int)1099, (int)url.getPort());
        JnpEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        JnpEndpointTestCase.assertEquals((String)"jnp://localhost:1099/BeeShirtsjnpServer?method=testMethod&endpointName=jnpProvider&blankParam=", (String)url.toString());
        JnpEndpointTestCase.assertEquals((String)"method=testMethod&endpointName=jnpProvider&blankParam=", (String)url.getQuery());
        JnpEndpointTestCase.assertEquals((int)3, (int)url.getParams().size());
        JnpEndpointTestCase.assertEquals((String)"testMethod", (String)url.getParams().getProperty("method"));
        JnpEndpointTestCase.assertEquals((String)"", (String)url.getParams().getProperty("blankParam"));
    }
}

