/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.AbstractMuleTestCase;

public class RmiEndpointTestCase
extends AbstractMuleTestCase {
    public void testHostPortUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("rmi://localhost:1099", muleContext);
        url.initialise();
        RmiEndpointTestCase.assertEquals((String)"rmi", (String)url.getScheme());
        RmiEndpointTestCase.assertEquals((String)"rmi://localhost:1099", (String)url.getAddress());
        RmiEndpointTestCase.assertNull((Object)url.getEndpointName());
        RmiEndpointTestCase.assertEquals((int)1099, (int)url.getPort());
        RmiEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        RmiEndpointTestCase.assertEquals((String)"rmi://localhost:1099", (String)url.getAddress());
        RmiEndpointTestCase.assertEquals((int)0, (int)url.getParams().size());
    }

    public void testQueryParams1() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("rmi://localhost:1099/BeeShirtsRmiServer?method=testMethod", muleContext);
        url.initialise();
        RmiEndpointTestCase.assertEquals((String)"rmi", (String)url.getScheme());
        RmiEndpointTestCase.assertEquals((String)"rmi://localhost:1099", (String)url.getAddress());
        RmiEndpointTestCase.assertEquals((String)"/BeeShirtsRmiServer", (String)url.getPath());
        RmiEndpointTestCase.assertNull((Object)url.getEndpointName());
        RmiEndpointTestCase.assertEquals((int)1099, (int)url.getPort());
        RmiEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        RmiEndpointTestCase.assertEquals((String)"rmi://localhost:1099/BeeShirtsRmiServer?method=testMethod", (String)url.toString());
        RmiEndpointTestCase.assertEquals((int)1, (int)url.getParams().size());
        RmiEndpointTestCase.assertEquals((String)"testMethod", (String)url.getParams().getProperty("method"));
    }

    public void testQueryParams2() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("rmi://localhost:1099/BeeShirtsRmiServer?method=testMethod&endpointName=rmiProvider&blankParam=", muleContext);
        url.initialise();
        RmiEndpointTestCase.assertEquals((String)"rmi", (String)url.getScheme());
        RmiEndpointTestCase.assertEquals((String)"rmi://localhost:1099", (String)url.getAddress());
        RmiEndpointTestCase.assertEquals((String)"/BeeShirtsRmiServer", (String)url.getPath());
        RmiEndpointTestCase.assertNotNull((Object)url.getEndpointName());
        RmiEndpointTestCase.assertEquals((String)"rmiProvider", (String)url.getEndpointName());
        RmiEndpointTestCase.assertEquals((int)1099, (int)url.getPort());
        RmiEndpointTestCase.assertEquals((String)"localhost", (String)url.getHost());
        RmiEndpointTestCase.assertEquals((String)"rmi://localhost:1099/BeeShirtsRmiServer?method=testMethod&endpointName=rmiProvider&blankParam=", (String)url.toString());
        RmiEndpointTestCase.assertEquals((String)"method=testMethod&endpointName=rmiProvider&blankParam=", (String)url.getQuery());
        RmiEndpointTestCase.assertEquals((int)3, (int)url.getParams().size());
        RmiEndpointTestCase.assertEquals((String)"testMethod", (String)url.getParams().getProperty("method"));
        RmiEndpointTestCase.assertEquals((String)"", (String)url.getParams().getProperty("blankParam"));
    }
}

