/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import org.mule.tck.FunctionalTestCase;
import org.mule.tck.jndi.InMemoryContext;
import org.mule.transport.rmi.DummySecurityManager;
import org.mule.transport.rmi.RmiConnector;

public class RmiNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "rmi-namespace-config.xml";
    }

    public void testConfig() throws Exception {
        RmiConnector c = (RmiConnector)muleContext.getRegistry().lookupConnector("rmiConnector");
        RmiNamespaceHandlerTestCase.assertNotNull((Object)c);
        RmiNamespaceHandlerTestCase.assertEquals((long)1234L, (long)c.getPollingFrequency());
        RmiNamespaceHandlerTestCase.assertEquals(DummySecurityManager.class, c.getSecurityManager().getClass());
        String url = c.getSecurityPolicy();
        RmiNamespaceHandlerTestCase.assertNotNull((Object)url);
        int index = url.lastIndexOf("/");
        RmiNamespaceHandlerTestCase.assertTrue((index > 0 ? 1 : 0) != 0);
        RmiNamespaceHandlerTestCase.assertEquals((String)"rmi.policy", (String)url.substring(index + 1));
        RmiNamespaceHandlerTestCase.assertEquals((String)"bcd", (String)c.getServerClassName());
        RmiNamespaceHandlerTestCase.assertEquals((String)"cde", (String)c.getServerCodebase());
        RmiNamespaceHandlerTestCase.assertEquals((String)"org.mule.tck.jndi.InMemoryContextFactory", (String)c.getJndiInitialFactory());
        RmiNamespaceHandlerTestCase.assertEquals((String)"efg", (String)c.getJndiProviderUrl());
        RmiNamespaceHandlerTestCase.assertEquals((String)"fgh", (String)c.getJndiUrlPkgPrefixes());
        RmiNamespaceHandlerTestCase.assertEquals((Object)"hij", c.getJndiProviderProperties().get("ghi"));
    }

    public void testConfig2() throws Exception {
        RmiConnector c = (RmiConnector)muleContext.getRegistry().lookupConnector("rmiConnector2");
        RmiNamespaceHandlerTestCase.assertNotNull((Object)c);
        RmiNamespaceHandlerTestCase.assertEquals((long)1234L, (long)c.getPollingFrequency());
        RmiNamespaceHandlerTestCase.assertEquals(DummySecurityManager.class, c.getSecurityManager().getClass());
        String url = c.getSecurityPolicy();
        RmiNamespaceHandlerTestCase.assertNotNull((Object)url);
        int index = url.lastIndexOf("/");
        RmiNamespaceHandlerTestCase.assertTrue((index > 0 ? 1 : 0) != 0);
        RmiNamespaceHandlerTestCase.assertEquals((String)"rmi.policy", (String)url.substring(index + 1));
        RmiNamespaceHandlerTestCase.assertEquals((String)"bcd", (String)c.getServerClassName());
        RmiNamespaceHandlerTestCase.assertEquals((String)"cde", (String)c.getServerCodebase());
        RmiNamespaceHandlerTestCase.assertTrue((boolean)(c.getJndiContext() instanceof InMemoryContext));
    }
}

