/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transport.AbstractMessageReceiverTestCase;
import org.mule.transport.rmi.RmiConnector;
import org.mule.transport.rmi.RmiMessageReceiver;
import org.mule.transport.rmi.SerializedMatchingMethodsComponent;
import org.mule.util.concurrent.Latch;

public class RmiMessageReceiverTestCase
extends AbstractMessageReceiverTestCase {
    private static Log LOGGER = LogFactory.getLog(RmiMessageReceiverTestCase.class);
    private RmiConnector connector = null;
    private RmiMessageReceiver messageReceiver = null;
    private Registry rmiRegistry = null;

    protected void doSetUp() throws Exception {
        this.registerRmi();
        this.connector = new RmiConnector(muleContext);
        this.connector.setName("TestConnector:" + ((Object)((Object)this)).getClass());
        this.connector.setSecurityPolicy(ClassLoader.getSystemResource("rmi.policy").getPath());
        this.connector.setJndiInitialFactory("com.sun.jndi.rmi.registry.RegistryContextFactory");
        this.connector.setJndiProviderUrl("rmi://localhost:11099");
        muleContext.getRegistry().registerConnector((Connector)this.connector);
        super.doSetUp();
    }

    public InboundEndpoint getEndpoint() throws Exception {
        if (this.endpoint == null) {
            EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("rmi://localhost:11099/TestMatchingMethodsComponent?method=reverseString", muleContext);
            if (this.connector == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage((String)"Connector has not been initialized."), null);
            }
            builder.setConnector((Connector)this.connector);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("methodArgumentTypes", "java.lang.String");
            properties.put("methodArgumentsList", Arrays.asList("test"));
            builder.setProperties(properties);
            this.endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
            return this.endpoint;
        }
        return this.endpoint;
    }

    public RmiMessageReceiver getMessageReceiver() throws Exception {
        if (this.messageReceiver == null) {
            this.messageReceiver = new RmiMessageReceiver((Connector)this.connector, (FlowConstruct)RmiMessageReceiverTestCase.getTestService(), this.getEndpoint(), 5000L){

                public void poll() {
                    super.poll();
                    RmiMessageReceiverTestCase.this.callbackCalled.countDown();
                }
            };
            this.messageReceiver.initialise();
        }
        return this.messageReceiver;
    }

    public void testReceive() throws Exception {
        RmiMessageReceiver messageReceiver = this.getMessageReceiver();
        RmiMessageReceiverTestCase.assertNull((Object)messageReceiver.invokeMethod);
        messageReceiver.connect();
        RmiMessageReceiverTestCase.assertNotNull((Object)messageReceiver.invokeMethod);
        this.callbackCalled = new Latch();
        messageReceiver.poll();
        RmiMessageReceiverTestCase.assertTrue((boolean)this.callbackCalled.await(1000L, TimeUnit.MILLISECONDS));
    }

    private void registerRmi() throws Exception {
        if (null == this.rmiRegistry) {
            this.rmiRegistry = LocateRegistry.createRegistry(11099);
            Naming.rebind("//localhost:11099/TestMatchingMethodsComponent", (Remote)((Object)new SerializedMatchingMethodsComponent()));
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
            InitialContext context = new InitialContext(env);
            SerializedMatchingMethodsComponent obj = (SerializedMatchingMethodsComponent)context.lookup("rmi://localhost:11099/TestMatchingMethodsComponent");
            if (obj == null) {
                throw new RuntimeException("Could not start RMI properly");
            }
        }
    }

    protected void doTearDown() throws Exception {
        try {
            this.messageReceiver.disconnect();
            this.messageReceiver.dispose();
            this.connector.disconnect();
            this.connector.dispose();
            UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.toString(), (Throwable)e);
        }
        super.doTearDown();
    }
}

