/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.Message;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.rmi.i18n.RmiMessages;

public abstract class AbstractFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    protected String prefix;

    public AbstractFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testCase() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.send("vm://testin", (Object)12, null);
        Assert.assertNotNull((Object)message);
        Integer payload = (Integer)message.getPayload();
        Assert.assertEquals((Object)payload, (Object)new Integer(22));
        message = client.send("vm://testin", (Object)"test matching component first time", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)((String)message.getPayload()), (Object)"emit tsrif tnenopmoc gnihctam tset");
        message = client.send("vm://testin", (Object)"test mathching component second time", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)((String)message.getPayload()), (Object)"emit dnoces tnenopmoc gnihchtam tset");
        message = client.send("vm://testin", (Object)15, null);
        Assert.assertNotNull((Object)message);
        payload = (Integer)message.getPayload();
        Assert.assertEquals((Object)payload, (Object)new Integer(25));
    }

    private MuleMessage send(String uri, String message) throws Exception {
        MuleClient client = new MuleClient(muleContext);
        return client.send(this.prefix + uri, (Object)message, new HashMap());
    }

    @Test
    public void testReverseString() throws Exception {
        MuleMessage message = this.send("://localhost/TestService?method=reverseString", "hello");
        Assert.assertNotNull((Object)message.getPayload());
        Assert.assertEquals((Object)"olleh", (Object)message.getPayloadAsString());
    }

    @Test
    public void testUpperCaseString() throws Exception {
        MuleMessage message = this.send("://localhost/TestService?method=upperCaseString", "hello");
        Assert.assertNotNull((Object)message.getPayload());
        Assert.assertEquals((Object)"HELLO", (Object)message.getPayloadAsString());
    }

    @Test
    public void testNoMethodSet() throws Exception {
        try {
            this.send("://localhost/TestService", "hello");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof DispatchException));
            Message message = RmiMessages.messageParamServiceMethodNotSet();
            Assert.assertTrue((String)("Expected to start with: " + message.toString() + "\n but was: " + e.getCause().getMessage()), (boolean)e.getCause().getMessage().startsWith(message.toString()));
        }
    }

    @Test
    public void testBadMethodName() throws Exception {
        try {
            this.send("://localhost/TestService?method=foo", "hello");
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NoSuchMethodException));
        }
    }

    @Test
    public void testBadMethodType() throws Exception {
        try {
            muleContext.getClient().send("BadType", (Object)"hello", null);
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NoSuchMethodException));
        }
    }

    @Test
    public void testCorrectMethodType() throws Exception {
        MuleMessage message = new MuleClient(muleContext).send("GoodType", (Object)"hello", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"olleh", (Object)message.getPayloadAsString());
    }
}

