/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jnp;

import org.junit.Assert;
import org.junit.Test;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class JnpEndpointTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testHostPortUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jnp://localhost:1099", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jnp", (Object)url.getScheme());
        Assert.assertEquals((Object)"jnp://localhost:1099", (Object)url.getAddress());
        Assert.assertNull((Object)url.getEndpointName());
        Assert.assertEquals((long)1099L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"jnp://localhost:1099", (Object)url.getAddress());
        Assert.assertEquals((long)0L, (long)url.getParams().size());
    }

    @Test
    public void testQueryParams1() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jnp://localhost:1099/BeeShirtsjnpServer?method=testMethod", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jnp", (Object)url.getScheme());
        Assert.assertEquals((Object)"jnp://localhost:1099", (Object)url.getAddress());
        Assert.assertEquals((Object)"/BeeShirtsjnpServer", (Object)url.getPath());
        Assert.assertNull((Object)url.getEndpointName());
        Assert.assertEquals((long)1099L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"jnp://localhost:1099/BeeShirtsjnpServer?method=testMethod", (Object)url.toString());
        Assert.assertEquals((long)1L, (long)url.getParams().size());
        Assert.assertEquals((Object)"testMethod", (Object)url.getParams().getProperty("method"));
    }

    @Test
    public void testQueryParams2() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jnp://localhost:1099/BeeShirtsjnpServer?method=testMethod&endpointName=jnpProvider&blankParam=", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jnp", (Object)url.getScheme());
        Assert.assertEquals((Object)"jnp://localhost:1099", (Object)url.getAddress());
        Assert.assertEquals((Object)"/BeeShirtsjnpServer", (Object)url.getPath());
        Assert.assertNotNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"jnpProvider", (Object)url.getEndpointName());
        Assert.assertEquals((long)1099L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"jnp://localhost:1099/BeeShirtsjnpServer?method=testMethod&endpointName=jnpProvider&blankParam=", (Object)url.toString());
        Assert.assertEquals((Object)"method=testMethod&endpointName=jnpProvider&blankParam=", (Object)url.getQuery());
        Assert.assertEquals((long)3L, (long)url.getParams().size());
        Assert.assertEquals((Object)"testMethod", (Object)url.getParams().getProperty("method"));
        Assert.assertEquals((Object)"", (Object)url.getParams().getProperty("blankParam"));
    }
}

