/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import org.junit.Assert;
import org.junit.Test;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class RmiEndpointTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testHostPortUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("rmi://localhost:1099", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"rmi", (Object)url.getScheme());
        Assert.assertEquals((Object)"rmi://localhost:1099", (Object)url.getAddress());
        Assert.assertNull((Object)url.getEndpointName());
        Assert.assertEquals((long)1099L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"rmi://localhost:1099", (Object)url.getAddress());
        Assert.assertEquals((long)0L, (long)url.getParams().size());
    }

    @Test
    public void testQueryParams1() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("rmi://localhost:1099/BeeShirtsRmiServer?method=testMethod", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"rmi", (Object)url.getScheme());
        Assert.assertEquals((Object)"rmi://localhost:1099", (Object)url.getAddress());
        Assert.assertEquals((Object)"/BeeShirtsRmiServer", (Object)url.getPath());
        Assert.assertNull((Object)url.getEndpointName());
        Assert.assertEquals((long)1099L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"rmi://localhost:1099/BeeShirtsRmiServer?method=testMethod", (Object)url.toString());
        Assert.assertEquals((long)1L, (long)url.getParams().size());
        Assert.assertEquals((Object)"testMethod", (Object)url.getParams().getProperty("method"));
    }

    @Test
    public void testQueryParams2() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("rmi://localhost:1099/BeeShirtsRmiServer?method=testMethod&endpointName=rmiProvider&blankParam=", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"rmi", (Object)url.getScheme());
        Assert.assertEquals((Object)"rmi://localhost:1099", (Object)url.getAddress());
        Assert.assertEquals((Object)"/BeeShirtsRmiServer", (Object)url.getPath());
        Assert.assertNotNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"rmiProvider", (Object)url.getEndpointName());
        Assert.assertEquals((long)1099L, (long)url.getPort());
        Assert.assertEquals((Object)"localhost", (Object)url.getHost());
        Assert.assertEquals((Object)"rmi://localhost:1099/BeeShirtsRmiServer?method=testMethod&endpointName=rmiProvider&blankParam=", (Object)url.toString());
        Assert.assertEquals((Object)"method=testMethod&endpointName=rmiProvider&blankParam=", (Object)url.getQuery());
        Assert.assertEquals((long)3L, (long)url.getParams().size());
        Assert.assertEquals((Object)"testMethod", (Object)url.getParams().getProperty("method"));
        Assert.assertEquals((Object)"", (Object)url.getParams().getProperty("blankParam"));
    }
}

