/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.jndi.InMemoryContext;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.rmi.DummySecurityManager;
import org.mule.transport.rmi.RmiConnector;

public class RmiNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "rmi-namespace-config.xml";
    }

    @Test
    public void testConfig() throws Exception {
        RmiConnector c = (RmiConnector)muleContext.getRegistry().lookupConnector("rmiConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1234L, (long)c.getPollingFrequency());
        Assert.assertEquals(DummySecurityManager.class, c.getSecurityManager().getClass());
        String url = c.getSecurityPolicy();
        Assert.assertNotNull((Object)url);
        int index = url.lastIndexOf("/");
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"rmi.policy", (Object)url.substring(index + 1));
        Assert.assertEquals((Object)"bcd", (Object)c.getServerClassName());
        Assert.assertEquals((Object)"cde", (Object)c.getServerCodebase());
        Assert.assertEquals((Object)"org.mule.tck.jndi.InMemoryContextFactory", (Object)c.getJndiInitialFactory());
        Assert.assertEquals((Object)"efg", (Object)c.getJndiProviderUrl());
        Assert.assertEquals((Object)"fgh", (Object)c.getJndiUrlPkgPrefixes());
        Assert.assertEquals((Object)"hij", c.getJndiProviderProperties().get("ghi"));
    }

    @Test
    public void testConfig2() throws Exception {
        RmiConnector c = (RmiConnector)muleContext.getRegistry().lookupConnector("rmiConnector2");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1234L, (long)c.getPollingFrequency());
        Assert.assertEquals(DummySecurityManager.class, c.getSecurityManager().getClass());
        String url = c.getSecurityPolicy();
        Assert.assertNotNull((Object)url);
        int index = url.lastIndexOf("/");
        Assert.assertTrue((index > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"rmi.policy", (Object)url.substring(index + 1));
        Assert.assertEquals((Object)"bcd", (Object)c.getServerClassName());
        Assert.assertEquals((Object)"cde", (Object)c.getServerCodebase());
        Assert.assertTrue((boolean)(c.getJndiContext() instanceof InMemoryContext));
    }
}

