/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.DefaultMuleMessage;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointNotFoundException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.MessageReceiver;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.servlet.MuleReceiverServlet;

public class MuleRESTReceiverServlet
extends MuleReceiverServlet {
    private static final long serialVersionUID = -2395763805839859649L;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (httpServletRequest.getParameter("endpoint") != null) {
                InboundEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
                String timeoutString = httpServletRequest.getParameter("timeout");
                long to = this.timeout;
                if (timeoutString != null) {
                    to = Long.parseLong(timeoutString);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
                }
                MuleMessage returnMessage = endpoint.request(to);
                this.writeResponse(httpServletResponse, returnMessage);
            } else {
                MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
                httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
                DefaultMuleMessage message = new DefaultMuleMessage((Object)receiver.getConnector().getMessageAdapter((Object)httpServletRequest));
                MuleMessage returnMessage = receiver.routeMessage((MuleMessage)message, true);
                this.writeResponse(httpServletResponse, returnMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to route event through Servlet Receiver", httpServletResponse);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            DefaultMuleMessage message = new DefaultMuleMessage((Object)receiver.getConnector().getMessageAdapter((Object)httpServletRequest));
            MuleMessage returnMessage = receiver.routeMessage((MuleMessage)message, true);
            this.writeResponse(httpServletResponse, returnMessage);
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule", httpServletResponse);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            DefaultMuleMessage message = new DefaultMuleMessage((Object)receiver.getConnector().getMessageAdapter((Object)httpServletRequest));
            receiver.routeMessage((MuleMessage)message, MuleServer.getMuleContext().getConfiguration().isDefaultSynchronousEndpoints());
            httpServletResponse.setStatus(201);
            if (this.feedback) {
                httpServletResponse.getWriter().write("Item was created at endpointUri: " + receiver.getEndpointURI());
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule" + e.getMessage(), httpServletResponse);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MuleMessage returnMessage;
            InboundEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
            String timeoutString = httpServletRequest.getParameter("timeout");
            long to = this.timeout;
            if (timeoutString != null) {
                to = new Long(timeoutString);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
            }
            if ((returnMessage = endpoint.request(to)) != null) {
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.setStatus(204);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Delete mule event via receive using uri: " + httpServletRequest.getPathInfo(), httpServletResponse);
        }
    }

    protected InboundEndpoint getEndpointForURI(HttpServletRequest httpServletRequest) throws MuleException {
        String endpointName = httpServletRequest.getParameter("endpoint");
        if (endpointName == null) {
            throw new EndpointException(HttpMessages.httpParameterNotSet((String)"endpoint"));
        }
        InboundEndpoint endpoint = RegistryContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointName);
        if (endpoint == null) {
            MessageReceiver receiver = (MessageReceiver)this.getReceivers().get(endpointName);
            if (receiver == null) {
                throw new EndpointNotFoundException(endpointName);
            }
            endpoint = receiver.getEndpoint();
        }
        return endpoint;
    }
}

