/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequest;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transport.servlet.HttpRequestMessageAdapter;
import org.mule.util.SystemUtils;

public class HttpRequestToParameter
extends AbstractMessageAwareTransformer {
    public HttpRequestToParameter() {
        this.registerSourceType(Object.class);
        this.setReturnClass(String.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        String payload;
        HttpServletRequest request = ((HttpRequestMessageAdapter)message.getAdapter()).getRequest();
        String payloadParam = (String)request.getAttribute("org.mule.servlet.payload.param");
        if (null == payloadParam) {
            payloadParam = "payload";
        }
        if (null == (payload = request.getParameter(payloadParam)) && this.isText(request.getContentType())) {
            try {
                InputStream is = (InputStream)message.getPayload();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, request.getCharacterEncoding()));
                StringBuffer buffer = new StringBuffer(8192);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                    if (line == null) continue;
                    buffer.append(SystemUtils.LINE_SEPARATOR);
                }
                payload = buffer.toString();
            }
            catch (IOException e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        }
        return payload;
    }

    protected boolean isText(String contentType) {
        if (contentType == null) {
            return true;
        }
        return contentType.startsWith("text/");
    }
}

