/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.DefaultMuleMessage;
import org.mule.RegistryContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.endpoint.DynamicURIInboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.servlet.AbstractReceiverServlet;
import org.mule.transport.servlet.HttpRequestMessageAdapter;
import org.mule.transport.servlet.ServletConnector;
import org.mule.transport.servlet.i18n.ServletMessages;
import org.mule.util.PropertiesUtils;

public class MuleReceiverServlet
extends AbstractReceiverServlet {
    private static final long serialVersionUID = 6631307373079767439L;
    protected ServletConnector connector = null;

    protected void doInit(ServletConfig servletConfig) throws ServletException {
        String servletConnectorName = servletConfig.getInitParameter("org.mule.servlet.connector.name");
        if (servletConnectorName == null) {
            this.connector = (ServletConnector)TransportFactory.getConnectorByProtocol((String)"servlet");
            if (this.connector == null) {
                throw new ServletException(ServletMessages.noConnectorForProtocolServlet().toString());
            }
        } else {
            this.connector = (ServletConnector)RegistryContext.getRegistry().lookupConnector(servletConnectorName);
            if (this.connector == null) {
                throw new ServletException(ServletMessages.noServletConnectorFound(servletConnectorName).toString());
            }
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MuleMessage responseMessage = this.doMethod(request, "HEAD");
            if (responseMessage != null) {
                this.writeResponse(response, responseMessage);
            } else {
                response.setStatus(200);
            }
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MuleMessage responseMessage = this.doMethod(request, "GET");
            this.writeResponse(response, responseMessage);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected void setupRequestMessage(HttpServletRequest request, MuleMessage requestMessage) {
        String reqUri = request.getRequestURI().toString();
        String queryString = request.getQueryString();
        if (queryString != null) {
            reqUri = reqUri + "?" + queryString;
        }
        requestMessage.setProperty("http.request", (Object)reqUri);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MuleMessage responseMessage = this.doMethod(request, "POST");
            if (responseMessage != null) {
                this.writeResponse(response, responseMessage);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected MuleMessage doMethod(HttpServletRequest request, String method) throws MuleException {
        MessageReceiver receiver = this.getReceiverForURI(request);
        DefaultMuleMessage requestMessage = new DefaultMuleMessage((Object)new HttpRequestMessageAdapter(request));
        requestMessage.setProperty("http.method", (Object)method);
        this.setupRequestMessage(request, (MuleMessage)requestMessage);
        return this.routeMessage(receiver, (MuleMessage)requestMessage, request);
    }

    protected MuleMessage routeMessage(MessageReceiver receiver, MuleMessage requestMessage, HttpServletRequest request) throws MuleException {
        return receiver.routeMessage(requestMessage, true);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MuleMessage responseMessage = this.doMethod(request, "OPTIONS");
            if (responseMessage != null) {
                this.writeResponse(response, responseMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MuleMessage responseMessage = this.doMethod(request, "PUT");
            if (responseMessage != null) {
                this.writeResponse(response, responseMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MuleMessage responseMessage = this.doMethod(request, "DELETE");
            if (responseMessage != null) {
                this.writeResponse(response, responseMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MuleMessage responseMessage = this.doMethod(request, "TRACE");
            if (responseMessage != null) {
                this.writeResponse(response, responseMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected void doConnect(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MuleMessage responseMessage = this.doMethod(request, "CONNECT");
            if (responseMessage != null) {
                this.writeResponse(response, responseMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, e.getMessage(), response);
        }
    }

    protected MessageReceiver getReceiverForURI(HttpServletRequest httpServletRequest) throws EndpointException {
        InboundEndpoint endpoint;
        String uri = this.getReceiverName(httpServletRequest);
        if (uri == null) {
            throw new EndpointException(HttpMessages.unableToGetEndpointUri((String)httpServletRequest.getRequestURI()));
        }
        MessageReceiver receiver = (MessageReceiver)this.getReceivers().get(uri);
        if (receiver == null) {
            int i = uri.lastIndexOf("/");
            if (i > -1) {
                String tempUri = uri.substring(i + 1);
                receiver = (AbstractMessageReceiver)this.getReceivers().get(tempUri);
            }
            if (receiver == null) {
                receiver = HttpMessageReceiver.findReceiverByStem((Map)this.connector.getReceivers(), (String)uri);
            }
            if (receiver == null) {
                receiver = HttpMessageReceiver.findReceiverByStem((Map)this.connector.getReceivers(), (String)uri);
            }
            if (receiver == null) {
                Map receivers = this.getReceivers();
                Iterator iter = receivers.keySet().iterator();
                while (iter.hasNext()) {
                    String key2;
                    String key = iter.next().toString();
                    i = key.lastIndexOf("/");
                    if (i <= -1 || !(key2 = key.substring(i + 1)).equals(uri)) continue;
                    receiver = (AbstractMessageReceiver)receivers.get(key);
                    break;
                }
            }
            if (receiver == null) {
                throw new NoReceiverForEndpointException("No receiver found for endpointUri: " + uri);
            }
        }
        if (!((endpoint = receiver.getEndpoint()) instanceof DynamicURIInboundEndpoint)) {
            endpoint = new DynamicURIInboundEndpoint(receiver.getEndpoint());
            receiver.setEndpoint(endpoint);
        }
        ((DynamicURIInboundEndpoint)endpoint).setEndpointURI((EndpointURI)new MuleEndpointURI(this.getRequestUrl(httpServletRequest)));
        try {
            receiver.getEndpointURI().initialise();
        }
        catch (InitialisationException e) {
            throw new EndpointException((Throwable)e);
        }
        return receiver;
    }

    protected String getRequestUrl(HttpServletRequest httpServletRequest) {
        StringBuffer url = new StringBuffer();
        url.append(this.connector.getProtocol().toLowerCase());
        url.append(":");
        url.append(httpServletRequest.getScheme());
        url.append("://");
        url.append(httpServletRequest.getServerName());
        url.append(":");
        url.append(httpServletRequest.getServerPort());
        url.append("/");
        url.append(this.getReceiverName(httpServletRequest));
        if (httpServletRequest.getQueryString() != null) {
            url.append("?");
            url.append(httpServletRequest.getQueryString());
        }
        return url.toString();
    }

    protected String getReceiverName(HttpServletRequest httpServletRequest) {
        Properties params;
        String name = httpServletRequest.getPathInfo();
        if (name == null && (name = httpServletRequest.getServletPath()) == null && (name = httpServletRequest.getParameter("endpoint")) == null && (name = (params = PropertiesUtils.getPropertiesFromQueryString((String)httpServletRequest.getQueryString())).getProperty("endpoint")) == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    protected Map getReceivers() {
        return this.connector.getReceivers();
    }
}

