/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractDiscoverableTransformer;

public class HttpRequestToByteArray
extends AbstractDiscoverableTransformer {
    public HttpRequestToByteArray() {
        this.registerSourceType(HttpServletRequest.class);
        this.setReturnClass(byte[].class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        try {
            IOUtils.copy((InputStream)((HttpServletRequest)src).getInputStream(), (OutputStream)baos);
        }
        catch (IOException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return baos.toByteArray();
    }
}

