/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.transformers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.util.SystemUtils;

public class HttpRequestToParameter
extends AbstractMessageAwareTransformer {
    public HttpRequestToParameter() {
        this.registerSourceType(Object.class);
        this.setReturnClass(String.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        String payloadParam = message.getStringProperty("org.mule.servlet.payload.param", "payload");
        String payload = message.getStringProperty(payloadParam, null);
        if (payload == null) {
            String contentType = message.getStringProperty("MULE_CONTENT_TYPE", null);
            if (contentType == null || contentType.startsWith("text/")) {
                try {
                    InputStream is = (InputStream)message.getPayload();
                    String characterEncoding = message.getStringProperty("MULE_CHARACTER_ENCODING", null);
                    BufferedReader reader = characterEncoding != null ? new BufferedReader(new InputStreamReader(is, characterEncoding)) : new BufferedReader(new InputStreamReader(is));
                    StringBuffer buffer = new StringBuffer(8192);
                    String line = reader.readLine();
                    while (line != null) {
                        buffer.append(line);
                        line = reader.readLine();
                        if (line == null) continue;
                        buffer.append(SystemUtils.LINE_SEPARATOR);
                    }
                    payload = buffer.toString();
                }
                catch (IOException e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
            }
            if (contentType.equals("application/x-www-form-urlencoded")) {
                InputStream is = (InputStream)message.getPayload();
                Properties props = new Properties();
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        throw new TransformerException((Transformer)this, (Throwable)e2);
                    }
                }
                return props.get(payloadParam);
            }
        }
        return payload;
    }
}

