/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MockHttpServletRequestBuilder {
    public static final String REQUEST_URI = "/services/Echo";
    public String method = "GET";
    public String requestUri = "/services/Echo";
    public ServletInputStream inputStream = null;
    public String payload = null;
    public String queryString = null;
    public Map<String, String[]> parameters = null;
    public String contentType = null;
    public HttpSession session = null;
    public String characterEncoding = null;
    public Map<String, String> attributes = new HashMap<String, String>();
    public Map<String, Object> headers = new HashMap<String, Object>();
    public String host = "localhost";
    public int localPort = 8080;
    public String pathInfo;

    public HttpServletRequest buildRequest() throws Exception {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getMethod()).thenReturn((Object)this.method);
        Enumeration emptyEnumeration = new Hashtable().elements();
        Mockito.when((Object)mockRequest.getParameterNames()).thenReturn(emptyEnumeration);
        Mockito.when((Object)mockRequest.getRequestURI()).thenReturn((Object)this.requestUri);
        Mockito.when((Object)mockRequest.getQueryString()).thenReturn((Object)this.queryString);
        Mockito.when((Object)mockRequest.getInputStream()).thenReturn((Object)this.inputStream);
        Mockito.when((Object)mockRequest.getSession(Matchers.anyBoolean())).thenReturn((Object)this.session);
        Mockito.when((Object)mockRequest.getCharacterEncoding()).thenReturn((Object)this.characterEncoding);
        Mockito.when((Object)mockRequest.getLocalPort()).thenReturn((Object)this.localPort);
        Mockito.when((Object)mockRequest.getContentType()).thenReturn((Object)this.contentType);
        Mockito.when((Object)mockRequest.getRemoteAddr()).thenReturn((Object)this.host);
        Mockito.when((Object)mockRequest.getHeader((String)Matchers.eq((Object)"Host"))).thenReturn((Object)this.host);
        Mockito.when((Object)mockRequest.getPathInfo()).thenReturn((Object)this.pathInfo);
        this.addParameterExpectations(mockRequest);
        this.addAttributeExpectations(mockRequest);
        this.addHeaderExpectations(mockRequest);
        return mockRequest;
    }

    private void addParameterExpectations(HttpServletRequest mockRequest) {
        IteratorEnumeration nameEnum = null;
        if (this.parameters != null) {
            Set<String> keys = this.parameters.keySet();
            nameEnum = new IteratorEnumeration(keys.iterator());
            for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
                String key = entry.getKey();
                String[] value = entry.getValue();
                Mockito.when((Object)mockRequest.getParameterValues((String)Matchers.eq((Object)key))).thenReturn((Object)value);
                Mockito.when((Object)mockRequest.getParameter((String)Matchers.eq((Object)key))).thenReturn(value.length > 0 ? value[0] : null);
            }
        }
        Mockito.when((Object)mockRequest.getParameterNames()).thenReturn(nameEnum);
        Mockito.when((Object)mockRequest.getParameterMap()).thenReturn(this.parameters);
    }

    private void addAttributeExpectations(HttpServletRequest mockRequest) {
        Enumeration<String> nameEnum = null;
        if (this.attributes != null) {
            nameEnum = this.keyEnumeration(this.attributes);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Mockito.when((Object)mockRequest.getAttribute((String)Matchers.eq((Object)key))).thenReturn((Object)value);
            }
        }
        Mockito.when((Object)mockRequest.getAttributeNames()).thenReturn(nameEnum);
    }

    private void addHeaderExpectations(HttpServletRequest mockRequest) {
        Enumeration<String> nameEnum = null;
        if (this.headers != null) {
            nameEnum = this.keyEnumeration(this.headers);
            for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Enumeration valueAsEnumeration = null;
                valueAsEnumeration = value instanceof Enumeration ? (Enumeration)value : new SingleElementEnumeration((String)value);
                Mockito.when((Object)mockRequest.getHeaders((String)Matchers.eq((Object)key))).thenReturn((Object)valueAsEnumeration);
            }
        }
        Mockito.when((Object)mockRequest.getHeaderNames()).thenReturn(nameEnum);
    }

    private Enumeration<String> keyEnumeration(Map<?, ?> map) {
        Set<?> keys = map.keySet();
        return new IteratorEnumeration(keys.iterator());
    }

    private static class SingleElementEnumeration
    implements Enumeration<String> {
        private String element;

        public SingleElementEnumeration(String singleElement) {
            this.element = singleElement;
        }

        @Override
        public boolean hasMoreElements() {
            return this.element != null;
        }

        @Override
        public String nextElement() {
            String retValue = this.element;
            if (this.element != null) {
                this.element = null;
            }
            return retValue;
        }
    }
}

