/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.servlet.AbstractReceiverServlet;

public class MuleReceiverServletTestCase
extends AbstractMuleTestCase {
    private static final String KEY = "key";
    private MuleContext mockContext = (MuleContext)Mockito.mock(MuleContext.class);

    @Test
    public void responseWithSingleValueForHeaderShouldWriteSingleValueToServletResponse() throws Exception {
        String headerValue = "value";
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.addHeader(new Header(KEY, headerValue));
        HttpServletResponse servletResponse = this.createServletResponseAndWriteResponse(httpResponse);
        ((HttpServletResponse)Mockito.verify((Object)servletResponse)).addHeader(KEY, headerValue);
    }

    @Test
    public void responseWithMultipleValuesForHeaderShouldWriteMultipleValuesToServletResponse() throws Exception {
        String firstValue = "value1";
        String secondValue = "value2";
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.addHeader(new Header(KEY, firstValue));
        httpResponse.addHeader(new Header(KEY, secondValue));
        HttpServletResponse servletResponse = this.createServletResponseAndWriteResponse(httpResponse);
        ((HttpServletResponse)Mockito.verify((Object)servletResponse)).addHeader(KEY, firstValue);
        ((HttpServletResponse)Mockito.verify((Object)servletResponse)).addHeader(KEY, secondValue);
    }

    @Test
    public void responseWithoutContentTypeHeaderShouldGetDefaultContentType() throws Exception {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.removeHeaders("Content-Type");
        HttpServletResponse servletResponse = this.createServletResponseAndWriteResponse(httpResponse);
        ((HttpServletResponse)Mockito.verify((Object)servletResponse)).setContentType("text/plain");
    }

    @Test
    public void responseWithExistingContentTypeHeaderShouldPreserve() throws Exception {
        String contentType = "foo/bar";
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.addHeader(new Header("Content-Type", contentType));
        HttpServletResponse servletResponse = this.createServletResponseAndWriteResponse(httpResponse);
        ((HttpServletResponse)Mockito.verify((Object)servletResponse)).setContentType(contentType);
    }

    private HttpServletResponse createServletResponseAndWriteResponse(HttpResponse httpResponse) throws Exception {
        HttpServletResponse servletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        TestReceiverServlet testServlet = new TestReceiverServlet();
        testServlet.writeResponse(servletResponse, (MuleMessage)new DefaultMuleMessage((Object)httpResponse, this.mockContext));
        return servletResponse;
    }

    private static class TestReceiverServlet
    extends AbstractReceiverServlet {
        private TestReceiverServlet() {
        }
    }
}

