/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.servlet.ServletConnector;

public class ServletConnectorTestCase
extends AbstractConnectorTestCase {
    public Connector createConnector() throws Exception {
        ServletConnector c = new ServletConnector(muleContext);
        c.setName("test");
        return c;
    }

    public String getTestEndpointURI() {
        return "servlet://testServlet";
    }

    public Object getValidMessage() throws Exception {
        return this.getMockRequest("test message");
    }

    private HttpServletRequest getMockRequest(final String message) {
        Object proxy = Proxy.newProxyInstance(ServletConnectorTestCase.class.getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){
            private String payload;
            private Map<Object, Object> props;
            {
                this.payload = message;
                this.props = new HashMap<Object, Object>();
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("getInputStream".equals(method.getName())) {
                    ServletInputStream s = new ServletInputStream(){
                        ByteArrayInputStream is;
                        {
                            this.is = new ByteArrayInputStream(payload.getBytes());
                        }

                        public int read() throws IOException {
                            return this.is.read();
                        }
                    };
                    return s;
                }
                if ("getAttribute".equals(method.getName())) {
                    return this.props.get(args[0]);
                }
                if ("setAttribute".equals(method.getName())) {
                    this.props.put(args[0], args[1]);
                } else {
                    if ("equals".equals(method.getName())) {
                        return this.payload.equals(args[0].toString());
                    }
                    if ("toString".equals(method.getName())) {
                        return this.payload;
                    }
                    if ("getReader".equals(method.getName())) {
                        return new BufferedReader(new StringReader(this.payload.toString()));
                    }
                    if ("getAttributeNames".equals(method.getName())) {
                        return new Hashtable().elements();
                    }
                    if ("getHeaderNames".equals(method.getName())) {
                        return new Hashtable().elements();
                    }
                }
                return null;
            }
        });
        return (HttpServletRequest)proxy;
    }

    public void testConnectorMessageDispatcherFactory() throws Exception {
    }

    public void testConnectorMessageDispatcher() throws Exception {
    }
}

