/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.servlet.MockHttpServletRequestBuilder;
import org.mule.transport.servlet.MockServletInputStream;
import org.mule.transport.servlet.ServletMuleMessageFactory;
import org.mule.util.UUID;

public class ServletMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final String CHARACTER_ENCODING_PROPERTY_KEY = "MULE_CHARACTER_ENCODING";
    private static final String CONTENT_TYPE_PROPERTY_KEY = "MULE_CONTENT_TYPE";
    private static final String PARAMETER_MAP_PROPERTY_KEY = "request.parameters";
    private static final String REQUEST_URI = "/services/Echo";
    private MuleMessageFactory factory;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.factory = this.createMuleMessageFactory();
    }

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new ServletMuleMessageFactory();
    }

    protected Object getValidTransportMessage() throws Exception {
        return new MockHttpServletRequestBuilder().buildRequest();
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is not a valid transport message for ServletMuleMessageFactory";
    }

    public void testValidPayload() throws Exception {
        Object payload = this.getValidTransportMessage();
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)REQUEST_URI, (Object)message.getPayload());
    }

    @Test
    public void testGetPayloadWithQueryParameter() throws Exception {
        MockHttpServletRequestBuilder builder = new MockHttpServletRequestBuilder();
        builder.queryString = "foo=bar";
        HttpServletRequest payload = builder.buildRequest();
        MuleMessage message = this.factory.create((Object)payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        String expected = "/services/Echo?" + builder.queryString;
        Assert.assertEquals((Object)expected, (Object)message.getPayload());
    }

    @Test
    public void testPostPayload() throws Exception {
        Object payload = this.buildPostRequest();
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertTrue((boolean)(message.getPayload() instanceof InputStream));
    }

    @Test
    public void testRequestParametersAreConvertedToMessageProperties() throws Exception {
        Object payload = this.buildPostRequest();
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        this.assertRequestParameterProperty("foo-value", message, "foo");
        this.assertRequestParameterProperty("bar-value", message, "bar");
        Map<String, Object> parameters = this.retrieveMapProperty(message, PARAMETER_MAP_PROPERTY_KEY);
        Assert.assertNotNull(parameters);
        Assert.assertEquals((Object)"foo-value", (Object)parameters.get("foo"));
        Assert.assertEquals((Object)"bar-value", (Object)parameters.get("bar"));
    }

    @Test
    public void testContentEncodingWithCharsetLast() throws Exception {
        String contentType = "text/plain;charset=UTF-21";
        Object payload = this.buildGetRequestWithContentType(contentType);
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        Assert.assertEquals((Object)"UTF-21", (Object)message.getEncoding());
        this.assertInboundScopedProperty(contentType, message, CONTENT_TYPE_PROPERTY_KEY);
    }

    @Test
    public void testContentEncodingWithCharsetFirst() throws Exception {
        String contentType = "charset=UTF-21;text/plain";
        Object payload = this.buildGetRequestWithContentType(contentType);
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        Assert.assertEquals((Object)"UTF-21", (Object)message.getEncoding());
        this.assertInboundScopedProperty(contentType, message, CONTENT_TYPE_PROPERTY_KEY);
    }

    @Test
    public void testMessageIdFromHttpSession() throws Exception {
        String sessionId = UUID.getUUID();
        Object payload = this.buildGetRequestWithSession(sessionId);
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        Assert.assertEquals((Object)sessionId, (Object)message.getInboundProperty("MULE_SESSION_ID"));
    }

    @Test
    public void testUniqueMessageId() throws Exception {
        String sessionId = UUID.getUUID();
        Object payload = this.buildGetRequestWithSession(sessionId);
        Object payload2 = this.buildGetRequestWithSession(sessionId);
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        MuleMessage message2 = this.factory.create(payload2, this.encoding, muleContext);
        Assert.assertEquals((Object)sessionId, (Object)message.getInboundProperty("MULE_SESSION_ID"));
        Assert.assertEquals((Object)sessionId, (Object)message2.getInboundProperty("MULE_SESSION_ID"));
        Assert.assertFalse((boolean)message.getUniqueId().equals(message2.getUniqueId()));
    }

    @Test
    public void testCharacterEncodingFromHttpRequest() throws Exception {
        MockHttpServletRequestBuilder builder = new MockHttpServletRequestBuilder();
        builder.characterEncoding = "UTF-21";
        HttpServletRequest payload = builder.buildRequest();
        MuleMessage message = this.factory.create((Object)payload, this.encoding, muleContext);
        this.assertInboundScopedProperty(builder.characterEncoding, message, CHARACTER_ENCODING_PROPERTY_KEY);
    }

    @Test
    public void testRequestPropertiesAreConvertedToMessageProperties() throws Exception {
        Object payload = this.buildGetRequestWithParameterValue("foo-param", "foo-value");
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        this.assertInboundScopedProperty("foo-value", message, "foo-param");
    }

    @Test
    public void testRequestAttributesAreConvertedToMessageProperties() throws Exception {
        Object payload = this.buildGetRequestWithAttributeValue("foo-attribute", "foo-value");
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        this.assertInboundScopedProperty("foo-value", message, "foo-attribute");
    }

    @Test
    public void testRequestHeadersAreConvertedToMessageProperties() throws Exception {
        Object payload = this.buildGetRequestWithHeaders();
        MuleMessage message = this.factory.create(payload, this.encoding, muleContext);
        this.assertInboundScopedProperty("foo-value", message, "foo-header");
        this.assertInboundScopedProperty("MULE_HEADER_VALUE", message, "MULE_HEADER");
        this.assertInboundScopedProperty("localhost:8080", message, "Host");
        Object[] expected = new Object[]{"value-one", "value-two"};
        Assert.assertTrue((boolean)Arrays.equals(expected, (Object[])message.getInboundProperty("multi-value")));
    }

    private void assertInboundScopedProperty(Object expected, MuleMessage message, String key) {
        Object value = message.getInboundProperty(key);
        Assert.assertEquals((Object)expected, (Object)value);
    }

    private void assertRequestParameterProperty(String expected, MuleMessage message, String key) {
        String propertyKey = "REQUEST_PARAMETER_" + key;
        Object value = message.getInboundProperty(propertyKey);
        Assert.assertEquals((Object)expected, (Object)value);
    }

    private Map<String, Object> retrieveMapProperty(MuleMessage message, String key) {
        return (Map)message.getInboundProperty(key);
    }

    private Object buildGetRequestWithContentType(String contentType) throws Exception {
        MockHttpServletRequestBuilder builder = new MockHttpServletRequestBuilder();
        builder.contentType = contentType;
        return builder.buildRequest();
    }

    private Object buildGetRequestWithSession(String sessionId) throws Exception {
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        MockHttpServletRequestBuilder builder = new MockHttpServletRequestBuilder();
        builder.session = session;
        return builder.buildRequest();
    }

    private Object buildGetRequestWithParameterValue(String key, String value) throws Exception {
        MockHttpServletRequestBuilder builder = new MockHttpServletRequestBuilder();
        builder.parameters = new HashMap<String, String[]>();
        builder.parameters.put(key, new String[]{value});
        return builder.buildRequest();
    }

    private Object buildGetRequestWithAttributeValue(String key, String value) throws Exception {
        MockHttpServletRequestBuilder builder = new MockHttpServletRequestBuilder();
        builder.attributes.put(key, value);
        return builder.buildRequest();
    }

    private Object buildGetRequestWithHeaders() throws Exception {
        MockHttpServletRequestBuilder builder = new MockHttpServletRequestBuilder();
        builder.headers.put("foo-header", "foo-value");
        builder.headers.put("X-MULE_HEADER", "MULE_HEADER_VALUE");
        builder.headers.put("Host", "localhost");
        Vector<String> multiValue = new Vector<String>();
        multiValue.add("value-one");
        multiValue.add("value-two");
        builder.headers.put("multi-value", multiValue.elements());
        return builder.buildRequest();
    }

    private Object buildPostRequest() throws Exception {
        MockHttpServletRequestBuilder builder = new MockHttpServletRequestBuilder();
        builder.method = "POST";
        ByteArrayInputStream stream = new ByteArrayInputStream("Test Message".getBytes());
        builder.inputStream = new MockServletInputStream(stream);
        builder.parameters = new HashMap<String, String[]>();
        builder.parameters.put("foo", new String[]{"foo-value"});
        builder.parameters.put("bar", new String[]{"bar-value"});
        return builder.buildRequest();
    }
}

