/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.servlet.CachedHttpServletRequest;
import org.mule.transport.servlet.MockServletInputStream;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.transport.servlet.ServletConnector;

public class CachedServletRequestTestCase
extends AbstractMuleContextTestCase {
    private static final String CONNECTOR_NAME = "ServletConnector";
    private ServletContext mockServletContext;
    private ServletConfig mockServletConfig;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.mockServletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)this.mockServletContext.getAttribute((String)Matchers.eq((Object)"mule.context"))).thenReturn((Object)muleContext);
        this.mockServletConfig = (ServletConfig)Mockito.mock(ServletConfig.class);
        Mockito.when((Object)this.mockServletConfig.getServletContext()).thenReturn((Object)this.mockServletContext);
        Mockito.when((Object)this.mockServletConfig.getInitParameter((String)Matchers.eq((Object)"org.mule.servlet.connector.name"))).thenReturn((Object)CONNECTOR_NAME);
    }

    @Test
    public void testReceiverServletUsingCachedServletRequest() throws Exception {
        this.registerServletConnector();
        SensingMuleReceiverServlet servlet = new SensingMuleReceiverServlet();
        servlet.init(this.mockServletConfig);
        HttpServletRequest mockRequest = this.createMockRequest();
        servlet.doGet(mockRequest, null);
        Assert.assertTrue((boolean)servlet.isUsingCachedServletRequest());
    }

    private void registerServletConnector() throws MuleException {
        ServletConnector connector = new ServletConnector(muleContext);
        connector.setName(CONNECTOR_NAME);
        connector.setUseCachedHttpServletRequest(true);
        muleContext.getRegistry().registerConnector((Connector)connector);
    }

    private HttpServletRequest createMockRequest() throws IOException {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getInputStream()).thenReturn((Object)new MockServletInputStream());
        Mockito.when((Object)mockRequest.getPathInfo()).thenReturn((Object)"/foo");
        return mockRequest;
    }

    private static class AbortControlFlowException
    extends RuntimeException {
    }

    private static class SensingMuleReceiverServlet
    extends MuleReceiverServlet {
        private boolean usingCachedServletRequest = false;

        protected MessageReceiver getReceiverForURI(HttpServletRequest request) throws EndpointException {
            this.usingCachedServletRequest = request instanceof CachedHttpServletRequest;
            throw new AbortControlFlowException();
        }

        protected void handleException(Throwable exception, String message, HttpServletResponse response) {
            Assert.assertTrue((boolean)(exception instanceof AbortControlFlowException));
        }

        public boolean isUsingCachedServletRequest() {
            return this.usingCachedServletRequest;
        }
    }
}

