/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.MessageReceiver;
import org.mule.transport.servlet.MuleReceiverServlet;

public class MuleRESTReceiverServlet
extends MuleReceiverServlet {
    private static final long serialVersionUID = -2395763805839859649L;

    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            InboundEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
            if (endpoint != null) {
                String timeoutString = httpServletRequest.getParameter("timeout");
                long to = this.timeout;
                if (timeoutString != null) {
                    to = Long.parseLong(timeoutString);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
                }
                MuleMessage returnMessage = endpoint.request(to);
                this.writeResponse(httpServletResponse, returnMessage);
            } else {
                MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
                httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
                MuleMessage message = receiver.createMuleMessage((Object)httpServletRequest);
                MuleEvent event = receiver.routeMessage(message);
                MuleMessage returnMessage = !receiver.getEndpoint().getExchangePattern().hasResponse() || event == null ? null : event.getMessage();
                this.writeResponse(httpServletResponse, returnMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to route event through Servlet Receiver", httpServletResponse);
        }
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            MuleMessage message = receiver.createMuleMessage((Object)httpServletRequest, receiver.getEndpoint().getEncoding());
            MuleEvent event = receiver.routeMessage(message);
            MuleMessage returnMessage = !receiver.getEndpoint().getExchangePattern().hasResponse() || event == null ? null : event.getMessage();
            this.writeResponse(httpServletResponse, returnMessage);
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule", httpServletResponse);
        }
    }

    @Override
    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            MuleMessage message = receiver.createMuleMessage((Object)httpServletRequest, receiver.getEndpoint().getEncoding());
            receiver.routeMessage(message);
            httpServletResponse.setStatus(201);
            if (this.feedback) {
                httpServletResponse.getWriter().write("Item was created at endpointUri: " + receiver.getEndpointURI());
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule" + e.getMessage(), httpServletResponse);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MuleMessage returnMessage;
            InboundEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
            String timeoutString = httpServletRequest.getParameter("timeout");
            long to = this.timeout;
            if (timeoutString != null) {
                to = new Long(timeoutString);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
            }
            if ((returnMessage = endpoint.request(to)) != null) {
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.setStatus(204);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Delete mule event via receive using uri: " + httpServletRequest.getPathInfo(), httpServletResponse);
        }
    }

    protected InboundEndpoint getEndpointForURI(HttpServletRequest httpServletRequest) throws MuleException {
        MessageReceiver receiver;
        InboundEndpoint endpoint;
        String uri;
        int i;
        String endpointName = httpServletRequest.getParameter("endpoint");
        if (endpointName == null && (i = (uri = httpServletRequest.getPathInfo()).lastIndexOf("/")) > -1) {
            endpointName = uri.substring(i + 1);
        }
        if ((endpoint = this.muleContext.getEndpointFactory().getInboundEndpoint(endpointName)) == null && (receiver = this.getReceivers().get(endpointName)) != null) {
            endpoint = receiver.getEndpoint();
        }
        return endpoint;
    }
}

