/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.EnumerationUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.transport.AbstractMuleMessageFactory;

public class ServletMuleMessageFactory
extends AbstractMuleMessageFactory {
    private static final String REMOTE_ADDRESS_HEADER = "remoteAddress";

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{HttpServletRequest.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        HttpServletRequest request = (HttpServletRequest)transportMessage;
        String method = request.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            return this.queryString(request);
        }
        return this.extractPayloadFromPostRequest(request);
    }

    protected Object extractPayloadFromPostRequest(HttpServletRequest request) throws Exception {
        request.getParameterNames();
        return request.getInputStream();
    }

    protected String queryString(HttpServletRequest request) {
        StringBuilder buf = new StringBuilder(request.getRequestURI());
        String queryString = request.getQueryString();
        if (queryString != null) {
            buf.append("?");
            buf.append(queryString);
        }
        return buf.toString();
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        HttpServletRequest request = (HttpServletRequest)transportMessage;
        this.setupRequestParameters(request, message);
        this.setupEncoding(request, (MuleMessage)message);
        this.setupSessionId(request, (MuleMessage)message);
        this.setupContentType(request, message);
        this.setupCharacterEncoding(request, message);
        this.setupRemoteAddress(request, message);
        this.setupMessageProperties(request, message);
    }

    protected void setupRequestParameters(HttpServletRequest request, DefaultMuleMessage message) {
        Enumeration parameterNames = request.getParameterNames();
        if (parameterNames != null) {
            HashMap<String, Object> parameterProperties = new HashMap<String, Object>();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                String key = "REQUEST_PARAMETER_" + name;
                String value = request.getParameterValues(name)[0];
                parameterProperties.put(key, value);
                parameterMap.put(name, value);
            }
            parameterProperties.put("request.parameters", parameterMap);
            parameterProperties.put("http.query.params", parameterMap);
            message.addInboundProperties(parameterProperties);
        }
    }

    protected void setupEncoding(HttpServletRequest request, MuleMessage message) {
        int index;
        String contentType = request.getContentType();
        if (contentType != null && (index = contentType.indexOf("charset")) > -1) {
            int semicolonIndex = contentType.lastIndexOf(";");
            String encoding = semicolonIndex > index ? contentType.substring(index + 8, semicolonIndex) : contentType.substring(index + 8);
            message.setEncoding(encoding.replaceAll("\"", "").trim());
        }
    }

    protected void setupSessionId(HttpServletRequest request, MuleMessage message) {
        try {
            HttpSession session = request.getSession(false);
            if (session != null) {
                ((DefaultMuleMessage)message).setInboundProperty("MULE_SESSION_ID", (Object)session.getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setupContentType(HttpServletRequest request, DefaultMuleMessage message) {
        String contentType = request.getContentType();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("MULE_CONTENT_TYPE", contentType);
        message.addInboundProperties(properties);
    }

    protected void setupCharacterEncoding(HttpServletRequest request, DefaultMuleMessage message) {
        String characterEncoding = request.getCharacterEncoding();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("MULE_CHARACTER_ENCODING", characterEncoding);
        message.addInboundProperties(properties);
    }

    protected void setupRemoteAddress(HttpServletRequest request, DefaultMuleMessage message) {
        message.setInboundProperty(REMOTE_ADDRESS_HEADER, (Object)request.getRemoteAddr());
    }

    protected void setupMessageProperties(HttpServletRequest request, DefaultMuleMessage message) {
        HashMap<String, Object> messageProperties = new HashMap<String, Object>();
        this.copyParameters(request, messageProperties);
        this.copyAttributes(request, messageProperties);
        this.copyHeaders(request, messageProperties);
        message.addInboundProperties(messageProperties);
    }

    protected void copyParameters(HttpServletRequest request, Map<String, Object> messageProperties) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap != null && parameterMap.size() > 0) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value != null && value.getClass().isArray() && ((Object[])value).length == 1) {
                    value = ((Object[])value)[0];
                }
                messageProperties.put(key, value);
            }
        }
    }

    protected void copyAttributes(HttpServletRequest request, Map<String, Object> messageProperties) {
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            messageProperties.put(key, request.getAttribute(key));
        }
    }

    protected void copyHeaders(HttpServletRequest request, Map<String, Object> messageProperties) {
        HashMap<String, Object[]> headers = new HashMap<String, Object[]>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            Object realValue;
            String key;
            String realKey = key = (String)e.nextElement();
            if (key.startsWith("X-MULE_")) {
                realKey = key.substring(2);
            }
            if ("Host".equalsIgnoreCase(key)) {
                realKey = "Host";
                String value = request.getHeader(key);
                int port = request.getLocalPort();
                if (!value.contains(":") && port != 80 && port != 443) {
                    value = value + ":" + port;
                }
                realValue = value;
            } else {
                Enumeration valueEnum = request.getHeaders(key);
                List values = EnumerationUtils.toList((Enumeration)valueEnum);
                realValue = values.size() > 1 ? values.toArray() : (values.size() == 1 ? values.get(0) : "");
            }
            headers.put(realKey, (Object[])realValue);
        }
        messageProperties.put("http.headers", headers);
        messageProperties.putAll(headers);
    }
}

