/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpConnector;
import org.mule.transport.sftp.SftpUtil;
import org.mule.transport.sftp.notification.SftpNotifier;

public class SftpMessageDispatcher
extends AbstractMessageDispatcher {
    private SftpConnector connector;
    private SftpUtil sftpUtil = null;

    public SftpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (SftpConnector)endpoint.getConnector();
        this.sftpUtil = new SftpUtil((ImmutableEndpoint)endpoint);
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doDispatch(MuleEvent event) throws Exception {
        InputStream inputStream;
        block16: {
            Object data = event.getMessage().getPayload();
            String filename = (String)event.getMessage().findPropertyInAnyScope("filename", null);
            if (filename == null) {
                MuleMessage message = event.getMessage();
                String outPattern = (String)this.endpoint.getProperty((Object)"outputPattern");
                if (outPattern == null) {
                    outPattern = (String)message.getProperty("outputPattern", (Object)this.connector.getOutputPattern());
                }
                filename = this.generateFilename(message, outPattern);
            }
            if (data instanceof byte[]) {
                byte[] buf = (byte[])data;
                inputStream = new ByteArrayInputStream(buf);
            } else if (data instanceof InputStream) {
                inputStream = (InputStream)data;
            } else {
                if (!(data instanceof String)) throw new IllegalArgumentException("Unexpected message type: java.io.InputStream, byte[], or String expected. Got " + data.getClass().getName());
                inputStream = new ByteArrayInputStream(((String)data).getBytes());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Writing file to: " + this.endpoint.getEndpointURI() + " [" + filename + "]"));
            }
            SftpClient client = null;
            boolean useTempDir = false;
            String transferFilename = null;
            try {
                String serviceName = event.getFlowConstruct() == null ? "UNKNOWN SERVICE" : event.getFlowConstruct().getName();
                SftpNotifier notifier = new SftpNotifier(this.connector, event.getMessage(), this.endpoint, serviceName);
                client = this.connector.createSftpClient(this.endpoint, notifier);
                String destDir = this.endpoint.getEndpointURI().getPath();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Connection setup successful, writing file.");
                }
                transferFilename = filename = client.duplicateHandling(destDir, filename, this.sftpUtil.getDuplicateHandling());
                useTempDir = this.sftpUtil.isUseTempDirOutbound();
                if (useTempDir) {
                    this.sftpUtil.cwdToTempDirOnOutbound(client, destDir);
                    boolean addUniqueSuffix = this.sftpUtil.isUseTempFileTimestampSuffix();
                    if (addUniqueSuffix) {
                        transferFilename = this.sftpUtil.createUniqueSuffix(transferFilename);
                    }
                }
                client.storeFile(transferFilename, inputStream);
                if (useTempDir) {
                    client.rename(transferFilename, destDir + "/" + filename);
                }
                this.logger.info((Object)("Successfully wrote file '" + filename + "' to " + this.endpoint.getEndpointURI()));
                if (client == null) break block16;
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)("Unexpected exception attempting to write file, message was: " + e.getMessage()), (Throwable)e);
                    this.sftpUtil.setErrorOccurredOnInputStream(inputStream);
                    if (!useTempDir) throw e;
                    String tempDir = this.sftpUtil.getTempDirOutbound();
                    this.sftpUtil.cleanupTempDir(client, transferFilename, tempDir);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        this.connector.releaseClient(this.endpoint, client);
                    }
                    inputStream.close();
                    throw throwable;
                }
            }
            this.connector.releaseClient(this.endpoint, client);
        }
        inputStream.close();
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    private String generateFilename(MuleMessage message, String pattern) {
        if (pattern == null) {
            pattern = this.connector.getOutputPattern();
        }
        return this.connector.getFilenameParser().getFilename(message, pattern);
    }
}

