/*
 * $Id: SpaceTransactionException.java 3167 2006-09-22 15:47:04 +0000 (Fri, 22 Sep 2006) holger $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the MuleSource MPL
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.impl.space;

import org.mule.config.i18n.Message;
import org.mule.config.i18n.Messages;
import org.mule.umo.space.UMOSpaceException;

/**
 * Is thrown when an error occurs during begin, commit or rollback of
 * a transaction.  There will always be a cause exception.
 *
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 3167 $
 */
public class SpaceTransactionException extends UMOSpaceException
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = -8131578773037713193L;

    public SpaceTransactionException(Throwable cause) {
        //todo better message
        super(new Message(Messages.FAILED_TO_INVOKE_X, "transaction"), cause);
    }
}
