/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.space;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.space.SpaceMonitorNotification;
import org.mule.impl.space.SpaceMonitorNotificationListener;
import org.mule.umo.UMOTransactionFactory;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.space.UMOSpace;
import org.mule.umo.space.UMOSpaceEvent;
import org.mule.umo.space.UMOSpaceEventListener;
import org.mule.umo.space.UMOSpaceException;

public abstract class AbstractSpace
implements UMOSpace {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List listeners = new CopyOnWriteArrayList();
    protected List monitorListeners = new CopyOnWriteArrayList();
    protected String name;
    protected boolean enableMonitorEvents;
    protected UMOTransactionFactory transactionFactory = null;

    protected AbstractSpace(String name) {
        this(name, true);
    }

    protected AbstractSpace(String name, boolean enableMonitorEvents) {
        this.name = name;
        this.enableMonitorEvents = enableMonitorEvents;
        this.fireMonitorEvent(901, this);
    }

    public void addListener(UMOSpaceEventListener listener) {
        this.listeners.add(listener);
        this.fireMonitorEvent(907, listener);
    }

    public void removeListener(UMOSpaceEventListener listener) {
        this.listeners.remove(listener);
        this.fireMonitorEvent(908, listener);
    }

    public void addMonitorListener(SpaceMonitorNotificationListener listener) {
        if (!this.enableMonitorEvents) {
            this.logger.warn((Object)("Space monitor notifications for " + this.name + " space are currently disabled"));
        }
        this.monitorListeners.add(listener);
    }

    public void removeMonitorListener(SpaceMonitorNotificationListener listener) {
        this.listeners.remove(listener);
    }

    public String getName() {
        return this.name;
    }

    public final void put(Object value) throws UMOSpaceException {
        this.doPut(value);
        this.fireListeners();
        this.fireMonitorEvent(902, value);
    }

    public void put(Object value, long lease) throws UMOSpaceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Writing value to space: " + this.name + ", with lease: " + lease + ", Value is: " + value));
        }
        this.doPut(value, lease);
        this.fireListeners();
        this.fireMonitorEvent(902, value);
    }

    public Object take() throws UMOSpaceException {
        Object item = this.doTake();
        if (item == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Taking from space: " + this.name + " returned null"));
            }
            this.fireMonitorEvent(905, item);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Taking from space: " + this.name + " returned:" + item));
            }
            this.fireMonitorEvent(903, item);
        }
        return item;
    }

    public Object take(long timeout) throws UMOSpaceException {
        Object item = this.doTake(timeout);
        if (item == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Taking from space (timeout " + timeout + "): returned null"));
            }
            this.fireMonitorEvent(905, item);
        } else {
            this.fireMonitorEvent(903, item);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Taking from space (timeout " + timeout + "): " + this.name + " returned:" + item));
            }
        }
        return item;
    }

    public Object takeNoWait() throws UMOSpaceException {
        Object item = this.doTakeNoWait();
        if (item == null) {
            this.fireMonitorEvent(905, item);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Taking from space (no wait): " + this.name + " returned: null"));
            }
        } else {
            this.fireMonitorEvent(903, item);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Taking from space (no wait): " + this.name + " returned:" + item));
            }
        }
        return item;
    }

    protected void fireListeners() {
        if (this.listeners.size() > 0) {
            Object item = null;
            try {
                item = this.takeNoWait();
            }
            catch (UMOSpaceException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
            if (item == null) {
                this.logger.warn((Object)"Item was taken before listeners could be updated, try using a different type of space");
                return;
            }
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                UMOSpaceEventListener spaceEventListener = (UMOSpaceEventListener)iterator.next();
                spaceEventListener.onEvent(new UMOSpaceEvent(item, this));
            }
        }
    }

    protected void fireMonitorEvent(int action, Object item) {
        if (this.enableMonitorEvents) {
            MuleManager.getInstance().fireNotification((UMOServerNotification)new SpaceMonitorNotification(this, action, item));
        }
    }

    public void dispose() {
        this.doDispose();
        this.fireMonitorEvent(906, this);
    }

    public UMOTransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public void setTransactionFactory(UMOTransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    protected abstract void doPut(Object var1) throws UMOSpaceException;

    protected abstract void doPut(Object var1, long var2) throws UMOSpaceException;

    protected abstract Object doTake() throws UMOSpaceException;

    protected abstract Object doTake(long var1) throws UMOSpaceException;

    protected abstract Object doTakeNoWait() throws UMOSpaceException;

    protected abstract void doDispose();
}

