/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.space;

import org.mule.impl.space.CreateSpaceException;
import org.mule.impl.space.DefaultSpace;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.space.UMOSpace;
import org.mule.umo.space.UMOSpaceException;
import org.mule.umo.space.UMOSpaceFactory;
import org.mule.util.queue.CachingPersistenceStrategy;
import org.mule.util.queue.MemoryPersistenceStrategy;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueuePersistenceStrategy;
import org.mule.util.xa.ResourceManagerSystemException;

public abstract class DefaultSpaceFactory
implements UMOSpaceFactory {
    private QueuePersistenceStrategy persistenceStrategy;
    private QueueManager queueManager;
    private boolean enableMonitorEvents = true;
    private int capacity = 0;
    private boolean enableCaching = false;

    public DefaultSpaceFactory() {
    }

    public DefaultSpaceFactory(boolean enableMonitorEvents) {
        this.enableMonitorEvents = enableMonitorEvents;
    }

    public DefaultSpaceFactory(boolean enableMonitorEvents, int capacity) {
        this.enableMonitorEvents = enableMonitorEvents;
        this.capacity = capacity;
    }

    public DefaultSpaceFactory(QueuePersistenceStrategy ps, boolean enableMonitorEvents) {
        this.persistenceStrategy = ps;
        this.enableMonitorEvents = enableMonitorEvents;
    }

    public DefaultSpaceFactory(QueuePersistenceStrategy ps, boolean enableMonitorEvents, int capacity) {
        this.persistenceStrategy = ps;
        this.enableMonitorEvents = enableMonitorEvents;
        this.capacity = capacity;
    }

    public DefaultSpaceFactory(QueueManager qm, boolean enableMonitorEvents) {
        this.queueManager = qm;
        this.enableMonitorEvents = enableMonitorEvents;
    }

    public boolean isEnableMonitorEvents() {
        return this.enableMonitorEvents;
    }

    public void setEnableMonitorEvents(boolean enableMonitorEvents) {
        this.enableMonitorEvents = enableMonitorEvents;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public QueuePersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public void setPersistenceStrategy(QueuePersistenceStrategy persistenceStrategy) {
        this.persistenceStrategy = persistenceStrategy;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    public boolean isEnableCaching() {
        return this.enableCaching;
    }

    public void setEnableCaching(boolean enableCaching) {
        this.enableCaching = enableCaching;
    }

    public UMOSpace create(String name) throws UMOSpaceException {
        if (this.capacity == 0) {
            this.capacity = 1024;
        }
        try {
            if (this.queueManager != null) {
                return new DefaultSpace(name, this.queueManager, this.enableMonitorEvents);
            }
            if (this.persistenceStrategy == null) {
                this.persistenceStrategy = new MemoryPersistenceStrategy();
            }
            if (this.enableCaching) {
                this.persistenceStrategy = new CachingPersistenceStrategy(this.persistenceStrategy);
            }
            return new DefaultSpace(name, this.persistenceStrategy, this.enableMonitorEvents, this.capacity);
        }
        catch (ResourceManagerSystemException e) {
            throw new CreateSpaceException(e);
        }
    }

    public UMOSpace create(UMOImmutableEndpoint endpoint) throws UMOSpaceException {
        return this.create(endpoint.getEndpointURI().getAddress());
    }
}

