/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.space;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.space.UMOSpace;
import org.mule.umo.space.UMOSpaceException;
import org.mule.umo.space.UMOSpaceFactory;
import org.mule.util.BeanUtils;

public class SpaceConnector
extends AbstractServiceEnabledConnector {
    private UMOSpaceFactory spaceFactory;
    private Map spaceProperties;
    private Map spaces = new HashMap();

    public String getProtocol() {
        return "space";
    }

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        if (this.spaceFactory == null) {
            throw new InitialisationException(new Message(45, (Object)"spaceFactory"), (Object)this);
        }
        if (this.spaceProperties != null) {
            BeanUtils.populateWithoutFail((Object)this.spaceFactory, (Map)this.spaceProperties, (boolean)true);
        }
    }

    public UMOSpace getSpace(String spaceUrl) throws UMOSpaceException {
        this.logger.info((Object)("looking for space: " + spaceUrl));
        UMOSpace space = (UMOSpace)this.spaces.get(spaceUrl);
        if (space == null) {
            this.logger.info((Object)("Space not found, creating space: " + spaceUrl));
            space = this.spaceFactory.create(spaceUrl);
            this.spaces.put(spaceUrl, space);
        }
        return space;
    }

    public UMOSpace getSpace(UMOImmutableEndpoint endpoint) throws UMOSpaceException {
        String spaceKey = this.getSpaceKey(endpoint);
        this.logger.info((Object)("looking for space: " + spaceKey));
        UMOSpace space = (UMOSpace)this.spaces.get(spaceKey);
        if (space == null) {
            this.logger.info((Object)("Space not found, creating space: " + spaceKey));
            space = this.spaceFactory.create(endpoint);
            this.spaces.put(spaceKey, space);
            if (endpoint.getTransactionConfig().getFactory() != null) {
                space.setTransactionFactory(endpoint.getTransactionConfig().getFactory());
            }
        }
        return space;
    }

    protected String getSpaceKey(UMOImmutableEndpoint endpoint) {
        return endpoint.getEndpointURI().toString();
    }

    public UMOSpaceFactory getSpaceFactory() {
        return this.spaceFactory;
    }

    public void setSpaceFactory(UMOSpaceFactory spaceFactory) {
        this.spaceFactory = spaceFactory;
    }

    public Map getSpaceProperties() {
        return this.spaceProperties;
    }

    public void setSpaceProperties(Map spaceProperties) {
        this.spaceProperties = spaceProperties;
    }

    protected void doDispose() {
        Iterator iterator = this.spaces.values().iterator();
        while (iterator.hasNext()) {
            UMOSpace space = (UMOSpace)iterator.next();
            space.dispose();
        }
        this.spaces.clear();
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        return super.getReceiverKey(component, endpoint) + (endpoint.getFilter() != null ? '#' + endpoint.getFilter().toString() : "");
    }
}

