/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.space;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.space.SpaceConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.space.UMOSpace;

public class SpaceMessageDispatcher
extends AbstractMessageDispatcher {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final SpaceConnector connector;
    private volatile UMOSpace space;

    public SpaceMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (SpaceConnector)endpoint.getConnector();
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws Exception {
        if (this.space == null) {
            this.space = this.connector.getSpace(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        try {
            this.space.dispose();
        }
        finally {
            this.space = null;
        }
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        long lease = event.getMessage().getLongProperty("lease", -1L);
        if (lease < 0L) {
            this.space.put(event.getTransformedMessage());
        } else {
            this.space.put(event.getTransformedMessage(), lease);
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return null;
    }

    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        Object result;
        String destination = endpoint.getEndpointURI().toString();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Connecting to space '" + destination + "'"));
        }
        if ((result = this.space.take(timeout)) == null) {
            return null;
        }
        return new MuleMessage((Object)this.connector.getMessageAdapter(result));
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected void doDispose() {
    }
}

