/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.space;

import java.util.Map;
import java.util.Properties;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.space.SpaceConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.space.UMOSpace;
import org.mule.umo.space.UMOSpaceException;

public class SpaceMessageReceiver
extends AbstractMessageReceiver
implements Work {
    private UMOSpace space;
    private SpaceConnector connector;

    public SpaceMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.connector = (SpaceConnector)connector;
    }

    public void doConnect() throws ConnectException {
        String destination = this.endpoint.getEndpointURI().getAddress();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.endpoint.getProperties());
        try {
            this.logger.info((Object)("Connecting to space: " + destination));
            this.space = this.connector.getSpace((UMOImmutableEndpoint)this.endpoint);
        }
        catch (UMOSpaceException e) {
            throw new ConnectException(new Message("space", 1, (Object)destination), (Throwable)((Object)e), (Object)this);
        }
        try {
            this.getWorkManager().scheduleWork((Work)this, Long.MAX_VALUE, null, (WorkListener)this.connector);
        }
        catch (WorkException e) {
            throw new ConnectException(new Message(151), (Throwable)e, (Object)this);
        }
    }

    public void doDisconnect() throws ConnectException {
    }

    public void run() {
        while (!this.disposing.get()) {
            if (!this.connector.isStarted() || this.disposing.get()) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Receiver starting on space: " + this.space));
            }
            try {
                Object message = this.space.take(Long.MAX_VALUE);
                Work work = this.createWork(this.space, message);
                try {
                    this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, (WorkListener)this.connector);
                }
                catch (WorkException e) {
                    this.logger.error((Object)("GS Server receiver Work was not processed: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void release() {
    }

    protected void doDispose() {
    }

    protected Work createWork(UMOSpace space, Object message) throws Exception {
        return new SpaceWorker(space, message);
    }

    protected class SpaceWorker
    implements Work {
        private UMOSpace space;
        private Object message;

        public SpaceWorker(UMOSpace space, Object message) {
            this.space = space;
            this.message = message;
        }

        public void release() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (SpaceMessageReceiver.this.logger.isTraceEnabled()) {
                    SpaceMessageReceiver.this.logger.trace((Object)("worker listening on space " + this.space));
                }
                UMOMessageAdapter adapter = SpaceMessageReceiver.this.connector.getMessageAdapter(this.message);
                UMOMessage uMOMessage = SpaceMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage((Object)adapter), SpaceMessageReceiver.this.endpoint.isSynchronous());
            }
            catch (Exception e) {
                SpaceMessageReceiver.this.handleException(e);
            }
            finally {
                this.release();
            }
        }
    }
}

