/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.space;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.ConnectException;
import org.mule.providers.TransactedPollingMessageReceiver;
import org.mule.providers.space.SpaceConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.space.UMOSpace;
import org.mule.umo.space.UMOSpaceException;

public class TransactedSpaceMessageReceiver
extends TransactedPollingMessageReceiver {
    private UMOSpace space;
    private SpaceConnector connector;

    public TransactedSpaceMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint, new Long(0L));
        this.connector = (SpaceConnector)connector;
        this.frequency = MapUtils.getLongValue((Map)endpoint.getProperties(), (Object)"frequency", (long)100000L);
    }

    protected List getMessages() throws Exception {
        Object message = this.space.take(this.frequency);
        if (message == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message received it is of type: " + message.getClass().getName()));
        }
        UMOMessageAdapter adapter = this.connector.getMessageAdapter(message);
        this.routeMessage((UMOMessage)new MuleMessage((Object)adapter), true);
        return null;
    }

    protected void processMessage(Object message) throws Exception {
    }

    public void doConnect() throws Exception {
        String destination = this.endpoint.getEndpointURI().getAddress();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.endpoint.getProperties());
        try {
            this.logger.info((Object)("Connecting to space: " + destination));
            this.space = this.connector.getSpace((UMOImmutableEndpoint)this.endpoint);
        }
        catch (UMOSpaceException e) {
            throw new ConnectException(new Message("space", 1, (Object)destination), (Throwable)((Object)e), (Object)this);
        }
    }

    public void doDisconnect() throws Exception {
    }

    public UMOSpace getSpace() {
        return this.space;
    }
}

